#ifndef VIDEODEVICE_TVCHANNEL_HPP
#define VIDEODEVICE_TVCHANNEL_HPP

#include <qobject.h>
#include <qstring.h>
#include <qvector.h>

class TVChannel: public QObject
{
public:
   /**
     Depending on the country, different frequency grids are used.
     I.e. in some countries the channels are spaced 7MHz apart, in
     others 8MHz. Also the CATV (cable TV) channels are different.
   */
   enum FrequencyGrid
   {
      FrequencyGrid_INVALID = -1,
      American = 0,
      European,
      Japanese,

      FrequencyGrid_MAX
   };

   /**
     For a description of tuner norms, see Wikipedia:
     http://en.wikipedia.org/wiki/Broadcast_television_system
   */
   enum TunerNorms {
     PAL_BG,
     NTSC,
     SECAM,
     PAL_NC,
     PAL_M,
     PAL_N,
     NTSC_JAPAN,

     TunerNorms_MAX,
   };

private:
   // There will be 3 tables with these structs, one for each Grid system
   struct FrequencyTableEntry
   {
     QString Name;
     float Frequency;
   };

   static bool s_TablesFilled;
   static QVector<FrequencyTableEntry> s_Channel2BaseFrequency[FrequencyGrid_MAX];

   static void FillTables();

public:
   QString Name;
   FrequencyGrid FrequencySystem;
   int Channel;
   int Finetuning;
   TunerNorms ColorSystem;

   TVChannel();
   TVChannel(const TVChannel &);
   TVChannel &operator = (const TVChannel &);

   float Frequency() const;
   static float Frequency(FrequencyGrid grid, int channel, int finetuning);
   static uint GetNumberOfChannels(FrequencyGrid grid);
   static QString ChannelName(FrequencyGrid grid, int channel);
};


#endif
