/***************************************************************************
 *   Copyright (C) 2005-2006 by Andreas Silberstorff   *
 *   ml@andreas-silberstorff.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.             *
 *                                                                         *
 *   In addition, as a special exception, the copyright holders give       *
 *   permission to link the code of this program with any edition of       *
 *   the Qt library by Trolltech AS, Norway (or with modified versions     *
 *   of Qt that use the same license as Qt), and distribute linked         *
 *   combinations including the two.  You must obey the GNU General        *
 *   Public License in all respects for all of the code used other than    *
 *   Qt.  If you modify this file, you may extend this exception to        *
 *   your version of the file, but you are not obligated to do so.  If     *
 *   you do not wish to do so, delete this exception statement from        *
 *   your version.                                                         *
 ***************************************************************************/
#include "kalva_player.h"
#include "kalvacmd.h"
#include "settings.h"

#include <qstring.h>
#include <qlineedit.h>

#include <klocale.h>
#include <kprocess.h>
#include <kinputdialog.h>
#include <kapplication.h>
#include <kmessagebox.h>
#include <kdebug.h>

#include <kdeversion.h>
#undef KDE_3_3_FEATURES
#if defined(KDE_MAKE_VERSION)
#if KDE_VERSION >= KDE_MAKE_VERSION(3,3,0)
	#define KDE_3_3_FEATURES
#endif
#endif

KalvaPlayer::KalvaPlayer(QWidget *parent, const char *name)
    : kalva_playergui(parent, name)
{
    m_proc = 0;
    playing = false;
}

void KalvaPlayer::slotPlay()
{
	if ( m_proc )
		delete m_proc;
	m_proc = 0;

	kdDebug() << "in slotPlay " << endl;

	cmd   = playCmd();

	if ( Settings::show_command() == true  ) {
#ifdef KDE_3_3_FEATURES
	bool ok;
	cmd = KInputDialog::getMultiLineText (
		i18n("Command to run"), 
		i18n("Command"), 
		cmd, 
		&ok,
		this,
		"cmdDlg"
	);
	if ( ok != true )  {
		return;
	}
#else
	int ret = KMessageBox::warningContinueCancel (
		this,
		cmd, 
		i18n("Command to run")
	);
	if ( ret != KMessageBox::Continue ) {
		return;
	}
#endif
	}
	m_proc = new KProcess;
	m_proc->setUseShell(true);
	QApplication::connect(
		m_proc, SIGNAL( processExited(KProcess *)),
		this,   SLOT( slotMplayerExited(KProcess *)));
	(*m_proc) << cmd;
	m_proc->start( KProcess::NotifyOnExit, KProcess::Stdin );
}

void KalvaPlayer::slotMplayerExited(KProcess *)
{
    kdDebug() << "In slotMplayerExited() " << endl;
}

void KalvaPlayer::settingsChanged( const QString& )
{
	if ( m_proc )  {
		kdDebug() << "mplayer process exists" << endl;
		if ( m_proc->isRunning() )  {
			kdDebug() << "Stop mplayer" << endl;
			if ( m_proc->kill() )  {
				kdDebug() << "Restart mplayer" << endl;
				slotPlay();
			}
		}
	}
}

void KalvaPlayer::stationChanged(const QString stat, const QString chan, const QString freq)
{
	kdDebug() << "Set channel to " << chan << endl;
	m_station->setText(stat );
	m_channel->setText(chan );
	m_frq->setText(freq );
	settingsChanged("");
}

QString KalvaPlayer::playCmd()
{
	KalvaCmd *myCmd = new KalvaCmd( this );
	myCmd->playCmd(   m_station->text(),
			  m_channel->text(),
			  m_frq->text()
			);
	return *myCmd;
}

void KalvaPlayer::play ()
{
   slotPlay();
}

#include "kalva_player.moc"
