/***************************************************************************
 *   Copyright (C) 2005-2006 by Andreas Silberstorff   *
 *   ml@andreas-silberstorff.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.             *
 *                                                                         *
 *   In addition, as a special exception, the copyright holders give       *
 *   permission to link the code of this program with any edition of       *
 *   the Qt library by Trolltech AS, Norway (or with modified versions     *
 *   of Qt that use the same license as Qt), and distribute linked         *
 *   combinations including the two.  You must obey the GNU General        *
 *   Public License in all respects for all of the code used other than    *
 *   Qt.  If you modify this file, you may extend this exception to        *
 *   your version of the file, but you are not obligated to do so.  If     *
 *   you do not wish to do so, delete this exception statement from        *
 *   your version.                                                         *
 ***************************************************************************/

#ifndef KALVA_RECORDER_H
#define KALVA_RECORDER_H

#include "kalva_recordgui.h"

class QLineEdit;
class QTabWidget;
class QCheckBox;
class KShellProcess;
class KMessageBox;
class KTimeWidget;
class KDatePicker;
class KHistoryCombo;
class KInputDialog;
class KProcess;
class KUser;

class KalvaRecorder : public kalva_recordergui
{
Q_OBJECT

public:
    KalvaRecorder(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    virtual ~KalvaRecorder();

    virtual QString recordNow(
                const QString & yourTitel,
                const QString & yourLength,
                bool  run = false
                );
    virtual QString recordMovie(
                const QString & yourTitel,
                const QString & yourLength,
                const QString & yourStartTime,
                const QString & yourStartDay,
                const QString & jobId = 0,
                bool  run = false
                );
    virtual QString recordSerial(
                const QString & yourTitel,
                const QString & yourLength,
                const QString & yourStartTime,
                const QString & yourDOWs,
                bool  run = false
                );

private:
    virtual QString recordCmd();
//     virtual QString recordCmdIVTV();
//     virtual QString recordCmdDVB();
//     virtual QString recordCmdDVBAsDivX4();

    QString setDOWs();
    QString setDayInDOWs( bool isChecked, QString dow, QString day );
    void unsetDOWs();
    void setYourDOWs ( const QString & yourDOWs );
    void setYourDayInDOWs ( const int & yourDOW );

    QString cmd;
    QString start;
    QString dow;
    KProcess* m_proc;
    KProcess* m_dcopProc;
    KUser*    m_user;

public slots:
    /*$PUBLIC_SLOTS$*/
    virtual void setWeekends();
    virtual void setLaborDays();
    virtual void setDaily();
    virtual void record();
    virtual void stationChanged(const QString stat, const QString chan,const QString freq);
    virtual void slotDelete();
    virtual void slotMoviesRead();

private slots:
    virtual void slotRecordNow();
    virtual void slotRecordMovie();
    virtual void slotRecordSerial();
    virtual void slotMencRecNowExited(KProcess * proc);
    virtual void slotMencRecMovieExited(KProcess * proc);
    virtual void slotMencRecSerialExited(KProcess * proc);
    virtual void slotNewMovie();

signals:
    void signalMovieScheduled();
    void signalDeleteMovie( const QString & jobid, bool ask );
    void signalSerialScheduled();
    void signalDeleteSerialFromCron();
};

#endif

