/***************************************************************************
 *   Copyright (C) 2005 by Andreas Silberstorff   *
 *   ml@andreas-silberstorff.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.             *
 *                                                                         *
 *   In addition, as a special exception, the copyright holders give       *
 *   permission to link the code of this program with any edition of       *
 *   the Qt library by Trolltech AS, Norway (or with modified versions     *
 *   of Qt that use the same license as Qt), and distribute linked         *
 *   combinations including the two.  You must obey the GNU General        *
 *   Public License in all respects for all of the code used other than    *
 *   Qt.  If you modify this file, you may extend this exception to        *
 *   your version of the file, but you are not obligated to do so.  If     *
 *   you do not wish to do so, delete this exception statement from        *
 *   your version.                                                         *
 ***************************************************************************/

#include <kdeversion.h>
#if KDE_IS_VERSION( 3, 2, 90 )

#include <kapplication.h>
#include <kdebug.h>
#include <ktar.h>
#include <kstandarddirs.h>
#include <klocale.h>
// #include <kdirlister.h>
#include <qdir.h>

#include "kalvanewstuff.h"
#include <knewstuff/entry.h>

/* default constructor */
KalvaNewStuff::KalvaNewStuff( QWidget *parent ) :
	KNewStuff( m_type,
		"http://download.kde.org/khotnewstuff/kalva-providers.xml",
		parent )
{
}

/* convenient constructor */
KalvaNewStuff::KalvaNewStuff( QString type , QString provider , QWidget *parent ) :
	KNewStuff( type,
		provider,
		parent ),
        m_type (type)
{
}

bool KalvaNewStuff::install( const QString &fileName )
{
     kdDebug() << "KalvaNewStuff::install(): " << fileName << endl;

     const QString destDir = KGlobal::dirs()->saveLocation("data",
                                         m_type, true);
     KStandardDirs::makeDir( destDir );
     return true;
}

QString KalvaNewStuff::downloadDestination ( KNS::Entry * entry )
{
     const QString destDir = KGlobal::dirs()->saveLocation("data",
                                        m_type, true);
     KStandardDirs::makeDir( destDir );
     QString dest = entry->name();
     dest.prepend("/");
     dest.prepend(destDir);
     return dest;
}

bool KalvaNewStuff::createUploadFile( const QString & /*fileName*/ ) {
	kdDebug() << i18n( "Uploading data is not possible yet!" );
	return false;
}

#endif // KDE >= 3.2.90
