//
// C++ Implementation: kalvaprofile
//
// Description: 
//
//
// Author: Andreas Silberstorff <ml@andreas-silberstorff.de>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kalvaprofile.h"

#include <qstring.h>
#include <qstringlist.h>
#include <qdir.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qmap.h>
#include <qregexp.h>

#include <kdebug.h>
#import <kglobal.h>
#import <klocale.h>
#include <kstandarddirs.h>

KalvaProfile::KalvaProfile( int type )
{
	switch( type ) {
		case( KALVA_CHANNELLIST ): {
			m_type = CHANNELLIST;
			break;
		}
		case KALVA_HARDWARE_PROFILE: {
			m_type = HARDWARE_PROFILE;
			break;
		}
		case KALVA_QUALITY_PROFILE: {
			 m_type = QUALITY_PROFILE;
			break;
		}
	}
}


KalvaProfile::~KalvaProfile()
{
}

QStringList KalvaProfile::readDir()
{
	QString dir = getDir();
	kdDebug() << i18n(QString("Going to read directory %1.")
                             .arg( dir )) << endl;

	QDir d = QDir( dir );
	if ( !d.exists() )
	{
	       kdWarning() << i18n(
                      QString("Cannot find the " + m_type + " directory %1!")
                              .arg( dir )) << endl;
	       return 0;
	}
	kdDebug() << i18n(QString("Read directory %1.")
                             .arg( dir )) << endl;
	d.setFilter( QDir::Files | QDir::Hidden | QDir::NoSymLinks );
	QStringList profiles = d.entryList();
	return profiles;
}

bool KalvaProfile::read( const QString basename )
{
	m_filename = basename;
	m_filename = m_filename.remove(QRegExp("^.*/"));
	m_profileData.clear();
	QString filename = getFilename();
	kdDebug() << "try to read profile from " << filename << endl;

	QFile file( filename );
	if (file.open(IO_ReadOnly) == false)
	{
		kdDebug() << i18n("could not open profile %1 for reading")
                        .arg( file.name() ) << endl;
		return false;
	}
	QTextStream prfFromFile(&file);
	QStringList prf = QStringList::split("\n",prfFromFile.read(),false);
	file.close();

	QString str;
	QString key;
	QString cat = "";
	QString val;

	for ( QStringList::Iterator it = prf.begin(); it != prf.end(); ++it ) {
		str = *it;
		kdDebug() << "read... " << str << endl;
		if ( str.startsWith( ("[") ) ) {
			cat = str;
		}  else  {
			key = str.section("=",0,0);
			val = str.section("=",1);
			setValue( key, cat, val );
		}
	}
	return true;
}

bool KalvaProfile::write( const QString name )
{
	kdDebug() << "write... " << name << endl;

//?????	m_profileData::Iterator it;
//        for ( it = m_profileData.begin(); it != m_profileData.end(); ++it ) {
//            printf( "key = %s, value = %s\n",
//                    it.key().latin1(),
//                    it.data().latin1() );
//        }

	return true;
}

QString KalvaProfile::getDir() {
	return KGlobal::dirs()->saveLocation( "data", "kalva/" + m_type, true);
}

QString KalvaProfile::getFilename() {
	return getDir() + "/" + m_filename;
}

QString KalvaProfile::getFilename( QString basename ) {
	m_filename = basename;
	m_filename = m_filename.remove(QRegExp("^.*/"));
	return getFilename();
}

Value KalvaProfile::getValue( const QString key )  {
	return m_profileData[ key ];
}

QString KalvaProfile::getCategory( const QString key )  {
	return getValue( key ).getCategory();
}

QString KalvaProfile::getValueString( const QString key )  {
	return getValue( key ).getValue();
}

int KalvaProfile::getValueInt( const QString key )  {
	return getValueString( key ).toInt();
}

double KalvaProfile::getValueDouble( const QString key )  {
	return getValueString( key ).toDouble();
}

float KalvaProfile::getValueFloat( const QString key )  {
	return getValueString( key ).toFloat();
}

bool KalvaProfile::getValueBoolean( const QString key )  {
	QString val = getValueString( key );
	if ( val.contains( "true" ) > 0 )
		return true;
	return false;
}

void KalvaProfile::setValue( const QString key, const QString cat, const QString val ) {
	kdDebug() << "setValue( " << key << ", " << cat << ", " << val <<  ")" << endl;
	m_profileData[ key ] = Value( cat, val );
}
