//
// C++ Implementation: kalvaprofilechoosercombo
//
// Description: 
//
//
// Author: Andreas Silberstorff <ml@andreas-silberstorff.de>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kalvaprofilechoosercombo.h"
#include "kalvaprofile.h"
#include "settings.h"

#include <qregexp.h>

#include <kcombobox.h>
#include <kdebug.h>

KalvaProfileChooserCombo::KalvaProfileChooserCombo(
		QWidget *parent,
		const char *name,
		const int type )
 : KComboBox( false, parent, name )
{
	m_type = type;
	m_profile = new KalvaProfile( type );
	connect( this,
		 SIGNAL( highlighted( const QString& ) ),
		 this,
		 SLOT( slotSetProfile( const QString& ) ) );
}

KalvaProfileChooserCombo::~KalvaProfileChooserCombo()
{
}

void KalvaProfileChooserCombo::read()  {
	clear();
	QStringList list = m_profile->readDir();
	insertStringList( list, -1 );
	QString currentText;

	switch( m_type ) {
		case KALVA_CHANNELLIST: {
			currentText = Settings::channellist();
			break;
		}
		case KALVA_HARDWARE_PROFILE: {
			currentText = Settings::hwprofile();
			break;
		}
		case KALVA_QUALITY_PROFILE: {
			currentText = Settings::qprofile();
			break;
		}
	}
	QString basename = currentText.remove( (QRegExp)".*/" );
	this->setCurrentText( basename );
}

void KalvaProfileChooserCombo::slotSetProfile( const QString& profile )  {
	kdDebug() << "in KalvaProfileChooserCombo::slotSetProfile" << endl;
	switch( m_type ) {
		case KALVA_CHANNELLIST: {
			Settings::setChlst( m_profile->getFilename() );
			break;
		}
		case KALVA_HARDWARE_PROFILE: {
			Settings::setHwprofile( profile );
			break;
		}
		case KALVA_QUALITY_PROFILE: {
			Settings::setQprofile( profile );
			break;
		}
	}
}

#include "kalvaprofilechoosercombo.moc"
