/***************************************************************************
 *   Copyright (C) 2005 by Andreas Silberstorff   *
 *   ml@andreas-silberstorff.de   *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 *   In addition, as a special exception, the copyright holders give
 *   permission to link the code of this program with any edition of
 *   the Qt library by Trolltech AS, Norway (or with modified versions
 *   of Qt that use the same license as Qt), and distribute linked
 *   combinations including the two.  You must obey the GNU General
 *   Public License in all respects for all of the code used other than
 *   Qt.  If you modify this file, you may extend this exception to
 *   your version of the file, but you are not obligated to do so.  If
 *   you do not wish to do so, delete this exception statement from
 *   your version.
 ***************************************************************************/

#ifndef _KALVASIDEBAR_H_
#define _KALVASIDEBAR_H_

#include <qwidget.h>
#include <qptrlist.h>

class QPixmap;
class QBoxLayout;
class KMultiTabBar;
class KConfigGroup;

/**
 * @short Kalva Side Bar
 * @author Andreas Silberstorff <ml@andreas-silberstorff.de>
 * @version 0.1
 */
class KalvaSideBar : public QWidget
{
	Q_OBJECT

public:
	KalvaSideBar(QWidget *parent);
	virtual ~KalvaSideBar();

	virtual int insertTab( QWidget* w,
			       const QPixmap & pix,
			       const QString & text);
	virtual void readConfig( const KConfigGroup& );
	virtual void setConfig( KConfigGroup& );

private slots:
	virtual void setTabVisibility(int Id);

private:
	KMultiTabBar*     m_KalvaSideBar;
        QBoxLayout*       m_Layout;
	QPtrList<QWidget> m_KalvaSideBarTab;
	int               m_ButtonCount;
};

#endif // _KALVASIDEBAR_H_
