/***************************************************************************
 *   Copyright (C) 2005 by Andreas Silberstorff   *
 *   ml@andreas-silberstorff.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.             *
 *                                                                         *
 *   In addition, as a special exception, the copyright holders give       *
 *   permission to link the code of this program with any edition of       *
 *   the Qt library by Trolltech AS, Norway (or with modified versions     *
 *   of Qt that use the same license as Qt), and distribute linked         *
 *   combinations including the two.  You must obey the GNU General        *
 *   Public License in all respects for all of the code used other than    *
 *   Qt.  If you modify this file, you may extend this exception to        *
 *   your version of the file, but you are not obligated to do so.  If     *
 *   you do not wish to do so, delete this exception statement from        *
 *   your version.                                                         *
 ***************************************************************************/

#ifndef _KALVAVIEW_H_
#define _KALVAVIEW_H_

#include <qwidget.h>
#include "kalva_player.h"
#include "kalvaviewdcopiface.h"

class QPainter;
class QSplitter;
class QTabWidget;
class KURL;

class KalvaSideBar;
class KalvaChannellist;
//class KalvaPlayer;
class KalvaRecorder;
class serialBrowser;
class movieBrowser;
class FileSelectorWidget;

/**
 * This is the main view class for Kalva.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * @short Main view
 * @author Andreas Silberstorff <ml@andreas-silberstorff.de>
 * @version 0.1
 */
class KalvaView : public QWidget,
                  virtual public KalvaviewDCOPInterface
{
    Q_OBJECT

public:
    KalvaView(QWidget *parent);
    virtual ~KalvaView();
    KalvaSideBar*     sidebar() const;
    KalvaChannellist* channellist() const;
    KalvaPlayer* player() { return m_player; };

    /* DCOP Interfaces */
    virtual ASYNC DcopMovieManagerRead();
    virtual QString DcopFuzzyStation(
                const QString & yourStation );
    virtual ASYNC DcopPlay(
                const QString & yourStation
                );
    virtual QString DcopRecordNow(
                const QString & yourStation,
                const QString & yourTitel,
                const QString & yourLength
                );
    virtual QString DcopRecordMovie(
                const QString & yourStation,
                const QString & yourTitel,
                const QString & yourLength,
                const QString & yourStartTime,
                const QString & yourStartDate
                );
    virtual QString DcopRecordSerial(
                const QString & yourStation,
                const QString & yourTitel,
                const QString & yourLength,
                const QString & yourStartTime,
                const QString & yourDOWs
                );
    virtual void recordSerial(
                const QString & yourStation,
                const QString & yourTitel,
                const QString & yourLength,
                const QString & yourStartTime,
                const QString & yourDOWs
                );
    virtual void recordMovie(
                const QString & yourStation,
                const QString & yourTitel,
                const QString & yourLength,
                const QString & yourStartTime,
                const QString & yourStartDay,
                const QString & yourJobId
                );

private:
    KalvaSideBar*           m_sidebar;
    QSplitter*              m_splitter;
    QTabWidget*             m_tabWidget;
    KalvaChannellist*       m_channellist;
    QWidget*                m_tabPlayer;
    QWidget*                m_tabRecorder;
    KalvaPlayer*            m_player;
    KalvaRecorder*          m_recorder;
    serialBrowser*          m_serialBrowser;
    movieBrowser*           m_movieBrowser;
    FileSelectorWidget*     m_videocollection;
    void warnChannelNotFound(const QString& text);
    QString getTimeFromInput(const QString& yourTime);
    QString underscoreToBlank(const QString& yourString);
    QString timeFromMinutes(const QString& yourTime);
    QString timeFromSeconds(const QString& yourTime);

signals:
    void signalChangeStatusbar(const QString& text);
    void signalChangeCaption(const QString& text);

private slots:
    void settingsChanged();
    void slotStationChanged();
};

#endif // _KALVAVIEW_H_
