/***************************************************************************
 *   Copyright (C) 2005 by Andreas Silberstorff   *
 *   ml@andreas-silberstorff.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.             *
 *                                                                         *
 *   In addition, as a special exception, the copyright holders give       *
 *   permission to link the code of this program with any edition of       *
 *   the Qt library by Trolltech AS, Norway (or with modified versions     *
 *   of Qt that use the same license as Qt), and distribute linked         *
 *   combinations including the two.  You must obey the GNU General        *
 *   Public License in all respects for all of the code used other than    *
 *   Qt.  If you modify this file, you may extend this exception to        *
 *   your version of the file, but you are not obligated to do so.  If     *
 *   you do not wish to do so, delete this exception statement from        *
 *   your version.                                                         *
 ***************************************************************************/
#ifndef KALVAVIEWDCOPIFACE_H
#define KALVAVIEWDCOPIFACE_H

#include <dcopobject.h>

class QString;

class KalvaviewDCOPInterface : virtual public DCOPObject
{
  K_DCOP

  k_dcop:
    virtual ASYNC DcopMovieManagerRead() = 0;
    virtual QString DcopFuzzyStation(
                const QString & yourStation
                ) = 0;
    virtual ASYNC DcopPlay(
                const QString & yourStation
                ) = 0;
    virtual QString DcopRecordNow(
                const QString & yourStation,
                const QString & yourTitel,
                const QString & yourLength         // HH:MM (optional :SS)
                ) = 0;
    virtual QString DcopRecordMovie(
                const QString & yourStation,
                const QString & yourTitel,
                const QString & yourLength,        // HH:MM (optional :SS)
                const QString & yourStartTime,     // HH:MM
                const QString & yourStartDate      // YYYY-MM-DD (ISO 8601)
                ) = 0;
    virtual QString DcopRecordSerial(
                const QString & yourStation,
                const QString & yourTitel,
                const QString & yourLength,        //HH:MM (optional :SS)
                const QString & yourStartTime,     //HH:MM (optional :SS)
                const QString & yourDOWs           //Days of the week (su = 1, mo = 2 etc., see "man crontab")
                ) = 0;
};

#endif
