/***************************************************************************
 *   Copyright (C) 2005-2006 by Andreas Silberstorff   *
 *   ml@andreas-silberstorff.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.             *
 *                                                                         *
 *   In addition, as a special exception, the copyright holders give       *
 *   permission to link the code of this program with any edition of       *
 *   the Qt library by Trolltech AS, Norway (or with modified versions     *
 *   of Qt that use the same license as Qt), and distribute linked         *
 *   combinations including the two.  You must obey the GNU General        *
 *   Public License in all respects for all of the code used other than    *
 *   Qt.  If you modify this file, you may extend this exception to        *
 *   your version of the file, but you are not obligated to do so.  If     *
 *   you do not wish to do so, delete this exception statement from        *
 *   your version.                                                         *
 ***************************************************************************/
#ifndef PREFS_H
#define PREFS_H

#include "prefs-base.h"
#include <kdeversion.h>
#undef KDE_3_3_FEATURES
#if defined(KDE_MAKE_VERSION)
#if KDE_VERSION >= KDE_MAKE_VERSION(3,3,0)
	#define KDE_3_3_FEATURES
	#include "kalvanewstuff.h"
#endif
#endif

class KalvaProfile;
class QString;
class QStringList;
class KProcess;
#ifdef KDE_3_3_FEATURES
class KalvaNewStuff;
#endif
class KDirWatch;

class Prefs : public Prefs_base
{
public:
	Prefs();
	virtual void loadAudiodevList();
	virtual void loadHWProfileChooser();
	virtual void loadQProfileChooser();
	virtual void loadChlstChooser();

public slots:
	virtual void aumixExited(KProcess *proc);
	virtual void setAudiodevList(KProcess *,
				char*  stdOutAudiodevs,
				int);
	virtual void slotSetAumixdev( const QString& audiodev );

private:
	void setCrop ();
	QStringList m_audiodevs;
	QString     m_hwprofiles_dir;
	QString     m_qprofiles_dir;
	QString     m_chlsts_dir;
	KalvaProfile* m_hwprofile;
	KalvaProfile* m_qprofile;
	KalvaProfile* m_chlst;
	KDirWatch*  hwprofilesWatcher;
	KDirWatch*  qprofilesWatcher;
	KDirWatch*  chlstsWatcher;
	KProcess*   m_proc;
#ifdef KDE_3_3_FEATURES
	KalvaNewStuff*  m_newHWProfiles;
	KalvaNewStuff*  m_newQProfiles;
	KalvaNewStuff*  m_newChlsts;
#endif

private slots:
	virtual void slotSetCrop( const QString & );
	virtual void slotSetCrop( double );
	virtual void slotLoadChlstChooser( const QString &path );
	virtual void slotSetChannellist(const QString &);
	virtual void slotOnLocationChanged(const QString &);
	virtual void slotOnTvTypeChanged(const QString &);
	virtual void slotUpdChlst(const QString &);
	virtual void slotLoadChlst(const QString &);
	virtual void slotSetChlstChanged();
	virtual void slotSaveChlst();
	virtual void slotDeleteChlst();
	virtual void slotDownloadChlst();
	virtual void slotUploadChlst();
	virtual void slotSetHWProfile(const QString &);
	virtual void slotLoadHWProfileChooser( const QString &path );
	virtual void slotUpdHWProfile(const QString &);
	virtual void slotSaveHWProfile();
	virtual void slotDeleteHWProfile();
	virtual void slotDownloadHWProfile();
	virtual void slotUploadHWProfile();
	virtual void slotLoadQProfileChooser( const QString &path );
	virtual void slotSetQProfile(const QString &);
	virtual void slotUpdQProfile(const QString &);
	virtual void slotSaveQProfile();
	virtual void slotDeleteQProfile();
	virtual void slotDownloadQProfile();
	virtual void slotUploadQProfile();
};
#endif
