//
// C++ Interface: $MODULE$
//
// Description: 
//
//
// Author: Andreas Silberstorff <andreas@andreas-silberstorff.de>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SERIALBROWSER_H
#define SERIALBROWSER_H
#include <qstring.h>

#include "serialbrowsergui.h"
class KProcess;
class KalvaView;

class serialBrowser: public serialBrowserGui
{
        Q_OBJECT

public:
    /* default constructor */
    serialBrowser(QWidget* parent = 0,
                           const char* name = 0,
                           WFlags fl = 0 );
   /* convenience constructor */
    serialBrowser(         KalvaView* view = 0,
                           QWidget* parent = 0,
                           const char* name = 0,
                           WFlags fl = 0 );
    ~serialBrowser();

public slots:
	virtual void slotRead();

private slots:
	virtual void slotCronlsExited(KProcess * proc);
	virtual void slotCronrmExited(KProcess *);
	virtual void slotSerialsReceived(KProcess *, char* Serial, int);
	virtual void slotEditSerial();
	virtual void slotDeleteSerial();
	virtual void slotSetTooltip(int, int);

private:
    QString          m_buf;
    KalvaView       *m_view;
    KProcess        *m_cronls;
    KProcess        *m_cronrm;
};

#endif
