/***************************************************************************
 *   Copyright (C) 2005 by Andreas Silberstorff   *
 *   ml@andreas-silberstorff.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.             *
 *                                                                         *
 *   In addition, as a special exception, the copyright holders give       *
 *   permission to link the code of this program with any edition of       *
 *   the Qt library by Trolltech AS, Norway (or with modified versions     *
 *   of Qt that use the same license as Qt), and distribute linked         *
 *   combinations including the two.  You must obey the GNU General        *
 *   Public License in all respects for all of the code used other than    *
 *   Qt.  If you modify this file, you may extend this exception to        *
 *   your version of the file, but you are not obligated to do so.  If     *
 *   you do not wish to do so, delete this exception statement from        *
 *   your version.                                                         *
 ***************************************************************************/

#include "tv_stationsfilterplugin.h"

#include <kgenericfactory.h>
#include <kaction.h>
#include <kfiledialog.h>

#include <qregexp.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qstringlist.h>
#include <qdir.h>

#include <kdebug.h>

K_EXPORT_COMPONENT_FACTORY( tv_stationsfilterplugin, KGenericFactory<tv_stationsFilterPlugin>( "tv_stationsfilterplugin" ) )

tv_stationsFilterPlugin::tv_stationsFilterPlugin(QObject *parent, const char* name, const QStringList&)
            : KChlstFilterPlugin::Plugin(parent, name )
{
    // Tell the host application to load my GUI component
    setInstance(KGenericFactory<tv_stationsFilterPlugin>::instance());

    // Create the actions of thus plugin
    m_actionImport = new KAction (i18n("from xawtv&4 (~/.tv/stations)"), "file",
                           0,
                           this, SLOT(slotImport()),
                           actionCollection(), "import_tv_stations");

    // Create the actions of thus plugin
    m_actionImport = new KAction (i18n("&xawtv4 from file"), "file",
                           0,
                           this, SLOT(slotImportFromFile()),
                           actionCollection(), "import_tv_stations_from_file");

    m_actionExport = new KAction (i18n("for xawtv&4 (~/.tv/stations)"), "file",
                           0,
                           this, SLOT(slotExport()),
                           actionCollection(), "export_tv_stations");

    setXMLFile("tv_stationsfilterpluginui.rc", true);

    m_actionImport->setEnabled(true);
    m_actionExport->setEnabled(false);

    // For ease announce that we have been loaded.
    kdDebug() << "tv_stationsFilterPlugin plugin loaded" << endl;
}


void tv_stationsFilterPlugin::slotImport()
{
    QString file = QString("%1/.tv/stations").arg(QDir::homeDirPath());
    import ( file );
}

void tv_stationsFilterPlugin::slotImportFromFile()
{
    QString file = KFileDialog::getOpenFileName (
               QDir::homeDirPath(),
               QString::null );
    if( file.isEmpty() )
    {
      return;
    }
    import ( file );
}

/***********************************************************************
 * this is the most simple example for an import filter because
 * this format is native and allmost no translation is needed.
 *
 ***@TODO: filter out options not relevant (see "man xawtvrc")
 ***********************************************************************/
void tv_stationsFilterPlugin::import ( const QString & _file )
{
    //kdDebug() << "xawtvrcFilterPlugin::slotImport() has been called" << endl;
    QFile file( _file );
    //kdDebug() << "file " << file.name() << " will be opened" << endl;
    //kdDebug() << "file " << file.name() << " will be opened" << endl;
    if (file.open(IO_ReadOnly) == false)
    {
        kdDebug() << "could not read file " << file.name() << endl;
        return;
    }
    //kdDebug() << "file " << file.name() << " successfully read" << endl;
    QTextStream tv_stations(&file);
    QString stations(tv_stations.read());
    stations = stations.replace( "channel = ", "channel=" );
    stations = stations.replace( "freq = ",    "freq=" );
    QStringList chlst = QStringList::split("\n",stations,false);
    file.close();
    //kdDebug() << "chlst read, emiting signal chlstImported" << endl;
    emit chlstImported( chlst );
}

void tv_stationsFilterPlugin::slotExport()
{
    kdDebug() << "tv_stationsFilterPlugin::slotExport() has been called" << endl;
    // read in the file, read in the data from the chlst
    // and write the date back without loosing the informations
    // that are not kept in the internal channellist format
}

#include "tv_stationsfilterplugin.moc"
