//
// C++ Implementation: kmidiiowindow
//
// Description: 
//
//
// Author: Luc Willems <willems.luc@pandora.be>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <kdebug.h>
#include "kmidiiowindow.h"
#include "ktrackframe.h"
#include <qlayout.h>

KmidiIOWindow::KmidiIOWindow(QWidget *parent, const char *name)
 : KDockMainWindow(parent,0)//,Qt::WType_Popup)
{
    m_midilayout= new QVBoxLayout(this);
    m_trackframe=new ktrackFrame(this);
    m_midilayout-> addSpacing(5);
    m_midilayout->addWidget(m_trackframe);
    m_midilayout-> addSpacing(5);
    m_midilayout->addStretch(0);
    setFixedHeight(m_trackframe->height()+10);
    //setFixedWidth(390);
    setCaption("Midi IO");
}


KmidiIOWindow::~KmidiIOWindow()
{
  kdDebug() << "delete KmidiIOWindow \n";
}

ktrackFrame* KmidiIOWindow::trackFrame()
{
  return m_trackframe;
}

bool KmidiIOWindow::queryClose()
{
  kdDebug() << "KmidiIOWindow queryClose() \n";
  emit hideIOWindow();
  return false;
}

void KmidiIOWindow::hide()
{
   kdDebug() << "KmidiIOWindow hide() \n";
   m_pos=pos();   // store position
   m_size=size();   // store size
   KDockMainWindow::hide();
}

void KmidiIOWindow::show()
{
  resize(m_size);        // restore size
  if ((m_pos.x() != 0) && (m_pos.y() != 0))
       move(m_pos);           // restore position
  KDockMainWindow::show();
}

#include "kmidiiowindow.moc"
