/***************************************************************************
 *   Copyright (C) 2005 by Luc Willems   *
 *   willems.luc@pandora.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KMIDIPLAYER_H
#define KMIDIPLAYER_H

#include <qobject.h>
#include <qthread.h>
#include <qstringlist.h>

#include "tse3/Transport.h"
#include "tse3/Progress.h"

class KProgressDialog;

namespace TSE3
{
 class Clock;
 namespace App
 {
   class Application;
 }
}

class QStringlist;



/**
@author Luc Willems
*/
class kmidiPlayer : public QObject,
                     public QThread,
                     public TSE3::TransportCallback,
                     public TSE3::Progress
{
Q_OBJECT

public:
    enum MidiStatus  { Midi_Stopped=1,Midi_Finished=2,Midi_beat=3 };
    enum PlayStatus  { stop=0,play=1,pause=2 };

    kmidiPlayer();
    ~kmidiPlayer();

   int initTSE3();

   int loadsong(QString filename);
   void Play(bool metronome=false);
   void Stop();
   void Pause();
   void Forward();
   void Back();
   void panic(); 
   void reset();
   void Shutdown();
   void setMetronome(bool b);
   int  getTempo();
   void setTempo( int bpm );
   void setPosition(int pos);
   int  getMidiPort();
   int  getEventTime();
   bool setMidiPort( int port ,bool isIndex=false);
   int  LastBeat();
   int  CurrentBeat();

   void progressRange(int min ,int max );
   void progress(int current);
   int  playStatus();

   QStringList* MidiPorts();
   QString* getMidiPortName( int port=-1 );

   // Thread handling
   int Status();
   TSE3::Song*    Song();

signals:
   void SongFinished();
   void SongStopped();
   void MidiReady();
   void MidiBeat();
   void MidiEvent(TSE3::MidiCommand m);

protected:
   void _setPanic(TSE3::Panic* panic);
   void _dostop();
   void _doreset();
   void _setmetronome(bool metronome);
   int  _gettempo();
   void _dopause();


   
   //gui thread event handling
   bool event( QEvent* e );
   //midi thread functions
   void sendMidiEvent(TSE3::MidiCommand m , bool input);
   void Transport_MidiIn(TSE3::MidiCommand m);
   void Transport_MidiOut(TSE3::MidiCommand m);
   void run();


   QStringList* getMidiPorts();

   TSE3::App::Application* m_tse3Appl;
   TSE3::Song*             m_song;
   int                     m_prevstate;
   int                     m_prevbr;
   int                     m_midiport;
   int			   t_lastbeat;
   int                     t_tempo;
   int                     m_eventtime;
   bool                    m_stopped;
   bool                    m_pause;
   bool                    m_shutdown;
   bool                    m_verbose;
   KProgressDialog*        m_progressdialog;
   PlayStatus              m_playstatus;
};


#endif
