/***************************************************************************
 *   Copyright (C) 2005 by Luc Willems   *
 *   willems.luc@pandora.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KMIDPLAY_H_
#define _KMIDPLAY_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kmainwindow.h>
#include <kurl.h>
#include <qtimer.h>

class Qtimer;
class kmidplayWidget;
class KmidiIOWindow;
class kmidiPlayer;

class Kaction;
class KSimpleConfig;


/**
 * @short Application Main Window
 * @author Luc Willems <willems.luc@pandora.be>
 * @version 0.1
 */

namespace TSE3
{
   class MidiCommand;
}
typedef QValueList<KURL> PlayList;

class kmidplay : public KMainWindow
{
   
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    kmidplay();

    /**
     * Default Destructor
     */
    virtual ~kmidplay();
    bool   m_playing;
    QTimer* looptimer;

    kmidplayWidget* playWidget;
    kmidiPlayer*    midiplayer;

public slots:
    //actions slots
    //file handling
    virtual void file_open();
    virtual void file_openRecent(const KURL &url);
    virtual void file_addRecent(const KURL &url);
    //playlist
    virtual void LoadUrl(const KURL &url);
    virtual void autoPlay(const KURL &url);

    //midi handling
    virtual void midi_play();
    virtual void midi_pause();
    virtual void midi_stop();
    virtual void midi_forward();
    virtual void midi_back();
    virtual void midi_loop();
    virtual void midi_metronome();
    virtual void midi_panic();
    virtual void midi_ready();
    virtual void midi_beat();
    virtual void midi_songFinished();
    virtual void midi_songStopped();
    virtual void midi_iowindow();

    virtual void toggleToolBar();
    virtual void toggleStatusBar();
    virtual void save_options();
    virtual void setToggleAction(const QString name);
    virtual void hideIOWindow();
    //others
    virtual void setBPM(int tempo);
    virtual void setPosition(int pos);
    virtual bool queryClose();
    virtual void midi_setup();
    virtual void midi_event(TSE3::MidiCommand m);

protected slots:
    void initObjects();

protected:
    void initWidgets();
    void setupActions();
    void setup();
    void savesetup();
    void setStatus(const QString s);
    KAction *recent;
    KURL *m_autourl;
    KSimpleConfig *m_config;
    KmidiIOWindow* m_midiwindow;
};

#endif // _KMIDPLAY_H_
