/***************************************************************************
 *   Copyright (C) 2005 by Luc Willems   *
 *   willems.luc@pandora.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <kdebug.h>
#include <qlabel.h>
#include <qtimer.h>
#include <qlayout.h>
#include <qslider.h>
#include <qnamespace.h>
#include <qpushbutton.h>

#include "lcd_digits.h"
#include "kmidplaywidget.h"
#include "ktrackframe.h"
#include <kglobal.h>
#include <kiconloader.h>


kmidplayWidget::kmidplayWidget(QWidget* parent, const char* name, WFlags fl)
        : QWidget(parent,name,fl),
    m_lastTenHours(-1),
    m_lastUnitHours(-1),
    m_lastTenMinutes(-1),
    m_lastUnitMinutes(-1),
    m_lastTenSeconds(-1),
    m_lastUnitSeconds(-1),
    m_lastTenths(-1),
    m_lastHundreths(-1),
    m_lastThousandths(-1),
    m_lastHundrethTempo(-1),
    m_lastTenthTempo(-1),
    m_lastUnitTempo(-1)
{
    /* Main external signals */
    initWidget();
    m_TempoChangeDelay=new QTimer();
}

kmidplayWidget::~kmidplayWidget()
{
  delete m_TempoChangeDelay;
}

void kmidplayWidget::initObjects()
{
 setLcdTime(0);
 setOriginalTempo(120);

 connect (m_TempoChangeDelay,SIGNAL(timeout()),
           this,SLOT(sendDelayTempoChange()));
 connect (TempoUp,SIGNAL(clicked()),
           this,SLOT(TempoUp_clicked()));
 connect (TempoDown,SIGNAL(clicked()),
           this,SLOT(TempoDown_clicked()));
 connect (slider1,SIGNAL(valueChanged(int)),
           this,SLOT(slider1_valueChanged(int)));
 connect (slider1,SIGNAL(sliderPressed()),
           this,SLOT(slider1_sliderPressed()));
 connect (slider1,SIGNAL(sliderReleased()),
           this,SLOT(slider1_sliderReleased()));

}

void kmidplayWidget::initWidget()
{
    //setup lcd pixmaps
    init_lcdList();

    LCDBoxFrame = new QFrame( this);
    LCDBoxFrame->setGeometry( QRect( 10, 10, 230, 60 ) );
    LCDBoxFrame->setFrameShape( QFrame::StyledPanel );
    LCDBoxFrame->setFrameShadow( QFrame::Plain );
    LCDBoxFrame->setPaletteBackgroundColor(Qt::black);
   
    TimeLabel = new QLabel( LCDBoxFrame);
    TimeLabel->setGeometry( QRect( 0, 0, 60, 20 ) );
    TimeLabel->setPaletteForegroundColor(QColor( 192, 216, 255) );
    QFont TimeLabel_font(  TimeLabel->font() );
    TimeLabel_font.setFamily( "System" );
    TimeLabel_font.setBold( TRUE );
    TimeLabel_font.setItalic( TRUE );
    TimeLabel->setFont( TimeLabel_font ); 

    NegativePixmap = new QLabel( LCDBoxFrame);
    NegativePixmap->setGeometry( QRect( 0, 20, 20, 34 ) );
    NegativePixmap->setPixmap(*(m_lcdminus));
    NegativePixmap->setScaledContents( TRUE );

    //hour
    TenHoursPixmap = new QLabel( LCDBoxFrame);
    TenHoursPixmap->setGeometry( QRect( 20, 20, 20, 34 ) );
    TenHoursPixmap->setScaledContents( TRUE );
    UnitHoursPixmap = new QLabel( LCDBoxFrame);
    UnitHoursPixmap->setGeometry( QRect( 40, 20, 20, 34 ) );
    UnitHoursPixmap->setScaledContents( TRUE );
    HourColonPixmap = new QLabel( LCDBoxFrame );
    HourColonPixmap->setGeometry( QRect( 60, 20, 5, 34 ) );
    HourColonPixmap->setPixmap(*(m_lcdcolon));
    HourColonPixmap->setScaledContents( TRUE );

    //minutes
    TenMinutesPixmap = new QLabel( LCDBoxFrame);
    TenMinutesPixmap->setGeometry( QRect( 65, 20, 20, 34 ) );
    TenMinutesPixmap->setScaledContents( TRUE );
    UnitMinutesPixmap = new QLabel( LCDBoxFrame);
    UnitMinutesPixmap->setGeometry( QRect( 85, 20, 20, 34 ) );
    UnitMinutesPixmap->setScaledContents( TRUE );
    MinuteColonPixmap_2 = new QLabel( LCDBoxFrame);
    MinuteColonPixmap_2->setGeometry( QRect( 105, 20, 5, 34 ) );
    MinuteColonPixmap_2->setPixmap(*(m_lcdcolon));
    MinuteColonPixmap_2->setScaledContents( TRUE );

    //seconds
    TenSecondsPixmap = new QLabel( LCDBoxFrame);
    TenSecondsPixmap->setGeometry( QRect( 110, 20, 20, 34 ) );
    TenSecondsPixmap->setScaledContents( TRUE );
    UnitSecondsPixmap = new QLabel( LCDBoxFrame);
    UnitSecondsPixmap->setGeometry( QRect( 130, 20, 20, 34 ) );
    UnitSecondsPixmap->setScaledContents( TRUE );
 
    //tenths & hunderdths seconds
    TenthsPixmap = new QLabel( LCDBoxFrame);
    TenthsPixmap->setGeometry( QRect( 156, 30, 14, 24 ) );
    TenthsPixmap->setScaledContents( TRUE );
    HundredthColonPixmap = new QLabel( LCDBoxFrame);
    HundredthColonPixmap->setGeometry( QRect( 150, 26, 4, 27 ) );
    HundredthColonPixmap->setPixmap(*(m_lcdcolon));
    HundredthColonPixmap->setScaledContents( TRUE );
    HundredthsPixmap = new QLabel( LCDBoxFrame);
    HundredthsPixmap->setGeometry( QRect( 170, 30, 14, 24 ) );
    HundredthsPixmap->setScaledContents( TRUE );
    ThousandthsPixmap = new QLabel( LCDBoxFrame);
    ThousandthsPixmap->setGeometry( QRect( 184, 30, 14, 24 ) );
    ThousandthsPixmap->setScaledContents( TRUE );


    LCDTempoFrame = new QFrame( this);
    LCDTempoFrame->setGeometry( QRect( 250, 10, 110, 60 ) );
    LCDTempoFrame->setFrameShape( QFrame::StyledPanel );
    LCDTempoFrame->setFrameShadow( QFrame::Plain );
    LCDTempoFrame->setPaletteBackgroundColor(Qt::black);

    TempoLabel = new QLabel( LCDTempoFrame);
    TempoLabel->setGeometry( QRect( 0, 0, 60, 20 ) );
    QFont TempoLabel_font(  TempoLabel->font() );
    TempoLabel_font.setFamily( "System" );
    TempoLabel_font.setBold( TRUE );
    TempoLabel_font.setItalic( TRUE );
    TempoLabel->setFont( TempoLabel_font ); 


    TempoHonderdPixmap = new QLabel( LCDTempoFrame);
    TempoHonderdPixmap->setGeometry( QRect( 10, 20, 20, 34 ) );
    TempoHonderdPixmap->setScaledContents( TRUE );


    TempoTenPixmap = new QLabel( LCDTempoFrame);
    TempoTenPixmap->setGeometry( QRect( 30, 20, 20, 34 ) );
    TempoTenPixmap->setScaledContents( TRUE );

    TempUnitPixmap = new QLabel( LCDTempoFrame);
    TempUnitPixmap->setGeometry( QRect( 50, 20, 20, 34 ) );
    TempUnitPixmap->setScaledContents( TRUE );

    TempoUp = new QPushButton( LCDTempoFrame);
    TempoUp->setGeometry( QRect( 84, 2, 20, 26 ) );
    TempoUp->setPaletteBackgroundColor( QColor( 192, 192, 192 ) );
    TempoUp->setMouseTracking( TRUE );
    TempoUp->setPixmap(m_up);
    TempoUp->setAutoRepeat( TRUE );
    TempoUp->setFocusPolicy (QWidget::NoFocus );

    TempoDown = new QPushButton( LCDTempoFrame);
    TempoDown->setGeometry( QRect( 84, 32, 20, 26 ) );
    TempoDown->setPaletteBackgroundColor( QColor( 192, 192, 192 ) );
    TempoDown->setMouseTracking( TRUE );
    TempoDown->setPixmap(m_down);
    TempoDown->setAutoRepeat( TRUE );
    TempoDown->setFocusPolicy (QWidget::NoFocus );

    slider1 = new QSlider( this );
    slider1->setGeometry( QRect( 10, 80, 350, 24 ) );
    slider1->setLineStep( 10 );
    slider1->setPageStep( 10 );
    slider1->setOrientation( QSlider::Horizontal );
    slider1->setTickmarks( QSlider::Above );
    slider1->setTickInterval( 4 );
    slider1->setFocusPolicy (QWidget::NoFocus );

    TimeLabel->setText( "Time" );
    TempoLabel->setText( "Tempo" );
}

void kmidplayWidget::init_lcdList()
{
  m_lcdlist[0]=new QPixmap( (const char **) led_0 );
  m_lcdlist[1]=new QPixmap( (const char **) led_1 );
  m_lcdlist[2]=new QPixmap( (const char **) led_2 );
  m_lcdlist[3]=new QPixmap( (const char **) led_3 );
  m_lcdlist[4]=new QPixmap( (const char **) led_4 );
  m_lcdlist[5]=new QPixmap( (const char **) led_5 );
  m_lcdlist[6]=new QPixmap( (const char **) led_6 );
  m_lcdlist[7]=new QPixmap( (const char **) led_7 );
  m_lcdlist[8]=new QPixmap( (const char **) led_8 );
  m_lcdlist[9]=new QPixmap( (const char **) led_9 );
  m_lcdminus  =new QPixmap( (const char **) led_minus );
  m_lcdcolon  =new QPixmap( (const char **) led_colon );

  //load up/down icons
  KIconLoader *loader = KGlobal::iconLoader();
  
  m_up = loader->loadIcon("1uparrow", KIcon::Toolbar);
  m_down = loader->loadIcon("1downarrow", KIcon::Toolbar);
}

void kmidplayWidget::update_lcdTime()
{
    int mseconds=m_lcdtime % 1000;
    int m_thousandths = ( mseconds / 1 ) % 10;
    int m_hundreths = ( mseconds / 10 ) % 10;
    int m_tenths = ( mseconds / 100 ) % 10;

    int seconds=m_lcdtime / 1000;
    int m_unitSeconds = ( seconds ) % 10;
    int m_tenSeconds = ( seconds / 10 ) % 6;

    int m_unitMinutes = ( seconds / 60 ) % 10;
    int m_tenMinutes = ( seconds / 600 ) % 6;

    int m_unitHours = ( seconds / 3600 ) % 10;
    int m_tenHours = (seconds / 36000 ) % 10;



    if (m_thousandths != m_lastThousandths)
    {
	if (m_thousandths < 0) 
           ThousandthsPixmap->clear();
	else 
           ThousandthsPixmap->setPixmap((*m_lcdlist[m_thousandths]));
        m_lastThousandths = m_thousandths;
    }

    if (m_hundreths != m_lastHundreths)
    {
	if (m_hundreths < 0) 
            HundredthsPixmap->clear();
        else 
            HundredthsPixmap->setPixmap((*m_lcdlist[m_hundreths]));
        m_lastHundreths = m_hundreths;
    }

    if (m_tenths != m_lastTenths)
    {
	if (m_tenths < 0) 
            TenthsPixmap->clear();
        else 
            TenthsPixmap->setPixmap((*m_lcdlist[m_tenths]));
        m_lastTenths = m_tenths;
    }

    if (m_unitSeconds != m_lastUnitSeconds)
    {
	if (m_unitSeconds < 0) 
            UnitSecondsPixmap->clear();
        else 
            UnitSecondsPixmap->setPixmap((*m_lcdlist[m_unitSeconds]));
        m_lastUnitSeconds = m_unitSeconds;
    }
 
    if (m_tenSeconds != m_lastTenSeconds)
    {
	if (m_tenSeconds < 0) 
            TenSecondsPixmap->clear();
        else 
            TenSecondsPixmap->setPixmap((*m_lcdlist[m_tenSeconds]));
        m_lastTenSeconds = m_tenSeconds;
    }

    if (m_unitMinutes != m_lastUnitMinutes)
    {
        if (m_unitMinutes < 0) 
            UnitMinutesPixmap->clear();
        else 
            UnitMinutesPixmap->setPixmap((*m_lcdlist[m_unitMinutes]));
        m_lastUnitMinutes = m_unitMinutes;
    }

    if (m_tenMinutes != m_lastTenMinutes)
    {
        if (m_tenMinutes < 0) 
            TenMinutesPixmap->clear();
        else 
            TenMinutesPixmap->setPixmap((*m_lcdlist[m_tenMinutes]));
        m_lastTenMinutes = m_tenMinutes;
    }

    if (m_unitHours != m_lastUnitHours)
    {
        if (m_unitHours < 0) 
            UnitHoursPixmap->clear();
        else 
            UnitHoursPixmap->setPixmap((*m_lcdlist[m_unitHours]));
        m_lastUnitHours = m_unitHours;
    }

    if (m_tenHours != m_lastTenHours)
    {
        if (m_tenHours < 0) 
            TenHoursPixmap->clear();
        else 
            TenHoursPixmap->setPixmap((*m_lcdlist[m_tenHours]));
        m_lastTenHours = m_tenHours;
    }

    if (m_lcdtime >= 0)
        NegativePixmap->clear();
    else
        NegativePixmap->setPixmap((*m_lcdminus));

}

void kmidplayWidget::setLcdTime(int msec)
{
    m_lcdtime=msec;
    update_lcdTime();
}

void kmidplayWidget::update_lcdTempo()
{
    //tempo
    int m_hundrethTempo = (m_tempo/100) % 10;
    int m_tenthTempo=(m_tempo/10) %10;
    int m_unitTempo=(m_tempo/1) % 10;

    if (m_hundrethTempo != m_lastHundrethTempo)
    {
	if (m_hundrethTempo < 0) 
            TempoHonderdPixmap->clear();
        else 
            TempoHonderdPixmap->setPixmap((*m_lcdlist[m_hundrethTempo]));
        m_lastHundrethTempo = m_hundrethTempo;
    }

    if (m_tenthTempo != m_lastTenthTempo)
    {
	if (m_tenthTempo < 0) 
            TempoTenPixmap->clear();
        else 
            TempoTenPixmap->setPixmap((*m_lcdlist[m_tenthTempo]));
        m_lastTenthTempo = m_tenthTempo;
    }

    if (m_unitTempo != m_lastUnitTempo)
    {
	if (m_unitTempo < 0) 
            TempUnitPixmap->clear();
        else 
            TempUnitPixmap->setPixmap((*m_lcdlist[m_unitTempo]));
        m_lastUnitTempo = m_unitTempo;
    }

    if (m_orgtempo == m_tempo)
        TempoLabel->setPaletteForegroundColor(0xC0D8FF);
    else if (m_orgtempo > m_tempo)
              TempoLabel->setPaletteForegroundColor(Qt::green);
          else
              TempoLabel->setPaletteForegroundColor(Qt::red);
}

void kmidplayWidget::setTempo(int tempo)
{
   if (tempo < 30)
       tempo=30;
   if (tempo > 255)
       tempo=255;
   m_tempo=tempo;
   update_lcdTempo();

   //emit to the world we changed something
   if ( m_TempoChangeDelay->isActive() )
       m_TempoChangeDelay->stop();
   m_TempoChangeDelay->start(500);
}

void kmidplayWidget::sendDelayTempoChange()
{
 m_TempoChangeDelay->stop();
 emit tempoChange(m_tempo);
} 

void kmidplayWidget::TempoDown_clicked()
{
   setTempo(m_tempo-1);
}

void kmidplayWidget::TempoUp_clicked()
{
   setTempo(m_tempo+1);
}

void kmidplayWidget::setOriginalTempo(int tempo)
{
  if (tempo < 30)
      tempo=30;
  if (tempo > 255)
      tempo=255;

  m_orgtempo=tempo;
  m_tempo=tempo;
  update_lcdTempo();
}

int kmidplayWidget::getTempo()
{
  return m_tempo;
}

bool kmidplayWidget::isTempoChanged()
{
  if (m_tempo != m_orgtempo)
      return true;
  return false;
}

void kmidplayWidget::setSliderMax(int pos)
{
  slider1->setMinValue(0);
  slider1->setMaxValue(pos);
  slider1->repaint();
}

void kmidplayWidget::setSliderPosition(int pos)
{
  if ( not m_usermoving)
      slider1->setValue(pos);
}

void kmidplayWidget::beat()
{

}

void kmidplayWidget::slider1_valueChanged(int i)
{
 //do something with i ?
 i++;
}

void kmidplayWidget::slider1_sliderPressed()
{
  m_usermoving=true;
}

void kmidplayWidget::slider1_sliderReleased()
{
  m_usermoving=false;
  emit positionChange(slider1->value());
}

#include "kmidplaywidget.moc"

