/***************************************************************************
 *   Copyright (C) 2005 by Luc Willems   *
 *   willems.luc@pandora.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KMIDPLAYWIDGET_H_
#define _KMIDPLAYWIDGET_H_

#include <qwidget.h> 
#include <qpixmap.h>

enum MidiMode { DISABLED, STANDBY , PLAYING , PAUSE ,STOP, METRONOME, PANIC ,MOVE_BEGIN , MOVE_END};
enum MetroMode { METRO_OFF, METRO_ON };

class QTimer;
class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QFrame;
class QLabel;
class QPushButton;
class QSlider;


class kmidplayWidget : public QWidget
{
    Q_OBJECT

public:
    kmidplayWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~kmidplayWidget();

    QFrame* LCDBoxFrame;
    QFrame* LCDTempoFrame;
    QLabel* MinuteColonPixmap_2;
    QLabel* TenHoursPixmap;
    QLabel* UnitHoursPixmap;
    QLabel* TenMinutesPixmap;
    QLabel* UnitMinutesPixmap;
    QLabel* NegativePixmap;
    QLabel* HourColonPixmap;
    QLabel* TimeLabel;
    QLabel* HundredthsPixmap;
    QLabel* TenSecondsPixmap;
    QLabel* UnitSecondsPixmap;
    QLabel* TenthsPixmap;
    QLabel* HundredthColonPixmap;
    QLabel* ThousandthsPixmap;
    QLabel* TempoTenPixmap;
    QLabel* TempUnitPixmap;
    QLabel* TempoLabel;
    QLabel* TempoHonderdPixmap;
    QSlider* slider1;
    QPushButton* TempoUp;
    QPushButton* TempoDown;

    /*$PUBLIC_FUNCTIONS$*/
    void setLcdTime(int msec);
    int  getTempo();
    bool isTempoChanged();
    void setOriginalTempo(int tempo);
    void setSliderMax(int pos);
    void setSliderPosition(int pos);
    void beat();

public slots:
    virtual void TempoDown_clicked();
    virtual void TempoUp_clicked();
    virtual void slider1_valueChanged(int i);
    virtual void slider1_sliderPressed();
    virtual void slider1_sliderReleased();
    virtual void initObjects();

signals:
   void tempoChange(int Tempo);
   void positionChange(int pos);

protected:
    void initWidget();
    
    /*$PROTECTED_FUNCTIONS$*/
    std::map<int, QPixmap*> m_lcdlist;
    QPixmap*  m_lcdminus;
    QPixmap*  m_lcdcolon;
    QPixmap   m_up;
    QPixmap   m_down;

    QTimer*   m_TempoChangeDelay;
    int       m_currenttime;
    int       m_currentempo;
    void init_lcdList();
    void update_lcdTime();
    void update_lcdTempo();
    void setTempo(int tempo);

    //LCD digits values
    int m_lastTenHours;
    int m_lastUnitHours;
    int m_lastTenMinutes;
    int m_lastUnitMinutes;
    int m_lastTenSeconds;
    int m_lastUnitSeconds;
    int m_lastTenths;
    int m_lastHundreths;
    int m_lastThousandths;
    int m_lcdtime;
    //tempo
    int m_lastHundrethTempo;
    int m_lastTenthTempo;
    int m_lastUnitTempo;
    int m_tempo;
    int m_orgtempo;
    bool m_usermoving;

protected slots:
    /*$PROTECTED_SLOTS$*/
    void sendDelayTempoChange();
};

#endif

