/***************************************************************************
 *   Copyright (C) 2005 by Luc Willems   *
 *   willems.luc@pandora.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KMIDTRACKVIEW_H
#define KMIDTRACKVIEW_H

#include <vector>
#include <qframe.h>

class QLabel;
//class KLedButton;
class KLed;
class VUMeter;

namespace TSE3
{
   class MidiCommand;
}

/**
@author Luc Willems
*/

class kmidTrackview : public QFrame
{
Q_OBJECT

public:
    kmidTrackview ( QWidget * parent , int id );
    ~kmidTrackview();
    int      trackid();
    void midi_event(TSE3::MidiCommand m);
    void PulsOn();
    void sysPulsOn();

    bool isDrum();
    QString noteName(int note);
    QString InstrumentGM1Name(int instrument);
    void createGM1();
    void show();


public slots:
     void midi_stop();
     void levelzero();
     void channeltimer();

    
protected:
   int m_id;
   int m_voices;
   int m_level;
   long int m_time;
   std::vector<int> voices;
   VUMeter*    m_vumeter;
   KLed*       m_channel;
   KLed*       m_syschannel;
   QLabel*     m_trackvoice;
   QLabel*     m_tracknote;
   QLabel*     m_trackinstrument;
   QTimer*     m_channeltimer;
   std::vector<QString>  m_drumnames;
   std::vector<QString>  m_gm1;

   void createdrumnames();
   void noteOn(int note);
   void noteOff(int note);
   void setVoiceCount();
   void setNoteNames();
};

#endif
