/***************************************************************************
 *   Copyright (C) 2005 by Luc Willems   *
 *   willems.luc@pandora.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kdebug.h>
#include <qlayout.h>
#include <qframe.h>
#include "tse3/Midi.h"
#include "ktrackframe.h"
#include "kmidtrackview.h"

ktrackFrame::ktrackFrame(QWidget *parent) 
      : QFrame(parent,0,0)
{
 m_tracklayout= new QVBoxLayout(this);
 maketracks();
 setFrameShape(QFrame::WinPanel );
 setFrameShadow(QFrame::Raised );
}

ktrackFrame::~ktrackFrame()
{
}

void ktrackFrame::maketracks()
{
 int size=0;
 kdDebug() << "Create channelviews\n";
 for (int i= 0; i < 16; i++)
 {
  kmidTrackview* track=new kmidTrackview(this,i);
  m_trackviews.push_back(track);
  m_tracklayout->addWidget(track);
  size += track->height();
 }
  setFixedHeight(size);
}

void ktrackFrame::midi_event(TSE3::MidiCommand m)
{
 if (m.channel >=0)
 {
  kmidTrackview* track=m_trackviews[m.channel];
  track->midi_event(m);
 }
}

void ktrackFrame::midi_stop()
{
 kdDebug() << "stop\n";
 for (int i= 0; i < 16; i++)
 {
   m_trackviews[i]->midi_stop();
 }
}

#include "ktrackframe.moc"
