/***************************************************************************
 *   Copyright (C) 2005 by Luc Willems   *
 *   willems.luc@pandora.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KTRACKFRAME_H
#define KTRACKFRAME_H

#include <vector>
#include <qframe.h>

class QVBoxLayout;
class kmidTrackview;

namespace TSE3
{
   class MidiCommand;
}

/**
@author Luc Willems
*/
class ktrackFrame : public QFrame
{
Q_OBJECT

public:
    ktrackFrame(QWidget *parent);
    ~ktrackFrame();

public slots:
    virtual void midi_event(TSE3::MidiCommand m);
    virtual void midi_stop();

protected:
    QVBoxLayout*                   m_tracklayout;
    std::vector<kmidTrackview* >   m_trackviews;
    void maketracks();

};

#endif
