/***************************************************************************
 *   Copyright (C) 2005 by Luc Willems   *
 *   willems.luc@pandora.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "config.h"
#include "kmidplay.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kicondialog.h>

static const char description[] =
    I18N_NOOP("A KDE Midi player based on TSE3");

static const char version[]   = VERSION;
static const char email[]     = "luc.will@gmail.com";
static const char author[]    = "Luc Willems";

static KCmdLineOptions options[] =
{
    { "l", I18N_NOOP("loop playlist"), 0 },
    { "m", I18N_NOOP("enable metronome"), 0 },
    { "p", I18N_NOOP("output midi port"), 0 },
    { "+[file]", I18N_NOOP("A midi file"), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("kmidplay", I18N_NOOP("kmidplay"), 
                     version, description,
                     KAboutData::License_GPL,author, 0, 0, email);
    about.addAuthor( author, 0, email );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );

    KApplication app;
    kmidplay *mainWin = 0;

    if (app.isRestored())
    {
        RESTORE(kmidplay);
    }
    else
    {
        /// @todo do something with the command line args here
        mainWin = new kmidplay();
        app.setMainWidget( mainWin );

        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        // Arguments (e.g. files to open)
        if (args->isSet("l"))
            mainWin->setToggleAction("midi_loop");
        if (args->isSet("m"))
            mainWin->setToggleAction("midi_metronome");
        mainWin->show();
        if (args->count()) 
        {
           //set song for autoplay
           mainWin->autoPlay(args->url(0).url());
        }

        args->clear();
    }

    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}

