/***************************************************************************
 *   Copyright (C) 2005 by Luc Willems   *
 *   willems.luc@pandora.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "midistatusevent.h"
#include "tse3/Midi.h"

MidiStatusEvent::MidiStatusEvent(int status)
 : QCustomEvent(midistatusEventid)
{
  m_status=status;
}

MidiStatusEvent::~MidiStatusEvent()
{
}

int MidiStatusEvent::getStatus()
{
  return m_status;
}


MidiIOEvent::MidiIOEvent(int msecclock , TSE3::MidiCommand m , bool input)
 : QCustomEvent(midiIOEventid)
{
  m_clock=msecclock;
  m_command = new TSE3::MidiCommand(m.status,m.channel,m.port,m.data1,m.data2);
  m_input=input;
}


MidiIOEvent::~MidiIOEvent()
{
  delete m_command;
}

int MidiIOEvent::getClock()
{
  return m_clock;
}

TSE3::MidiCommand* MidiIOEvent::getCommand()
{
  return m_command;
}

bool MidiIOEvent::isMidiIN()
{
  return m_input;
}

bool MidiIOEvent::isMidiOUT()
{
  return not m_input;
}
