/***************************************************************************
 *   Copyright (C) 2005 by Luc Willems   *
 *   willems.luc@pandora.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MIDISTATUSEVENT_H
#define MIDISTATUSEVENT_H

#include <qevent.h>
static int midistatusEventid= QEvent::User+1;
static int midiIOEventid= QEvent::User+2;

namespace TSE3
{
   class MidiCommand;
}

/**
@author Luc Willems
*/

class MidiStatusEvent : public QCustomEvent
{
public:
    MidiStatusEvent(int status);
    ~MidiStatusEvent();
    int getStatus();
protected:
    int m_status;
};

class MidiIOEvent : public QCustomEvent
{
public:
    MidiIOEvent(int msecclock , TSE3::MidiCommand m , bool input=false);
    ~MidiIOEvent();
    bool isMidiIN();
    bool isMidiOUT();
    int getClock();
    TSE3::MidiCommand* getCommand();

protected:
    int m_clock;
    bool m_input;
    TSE3::MidiCommand* m_command;
};

#endif
