// -*- c-basic-offset: 4 -*-

/*
    Rosegarden-4
    A sequencer and musical notation editor.

    This program is Copyright 2000-2005
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <bownie@bownie.com>

    The moral right of the authors to claim authorship of this work
    has been asserted.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include <qframe.h>
#include <qpainter.h>
#include <qtimer.h>

#include "velocitycolour.h"

#ifndef _VUMETER_H_
#define _VUMETER_H_

class VUMeter : public QFrame
{
Q_OBJECT

public:
    typedef enum
    {
        Horizontal,
        Vertical
    } VUAlignment;

    VUMeter(QWidget *parent = 0,
            int width = 0,
            int height = 0,
            VUAlignment alignment = Horizontal,
            const char *name = 0);
    ~VUMeter();

    virtual void paintEvent(QPaintEvent*);
    // Mono and stereo level setting.  The AudioPeakHold meter types
    // expect levels in dB; other types expect levels between 0 and 1.
    //
    void setLevel(int Level,  bool startfall);
    void startFallTimer(int time=20);

signals:
   void levelzero();

protected:
    int         m_originalHeight;

private slots:
    void slotReduceLevelLeft();
    void slotStopShowingPeakLeft();

private:

    void drawMeterLevel(QPainter *paint);
    void drawColouredBar(QPainter *paint, int x, int y, int w, int h);

    VUAlignment m_alignment;
    QColor      m_background;

    int         m_maxLevel;
    int         m_level;
    int         m_peakLevel;
    int         m_levelStep;
    QTimer     *m_fallTimer;
    QTimer     *m_peakTimer;

    bool        m_showPeakLevel;
    short       m_baseLevelStep;

    // We use this to work out our colours
    //
    VelocityColour *m_velocityColour;


};

#endif // _VUMETER_H_
