/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
using namespace std;

#ifndef _MPLAYERINTERFACE_H_
#define _MPLAYERINTERFACE_H_

#include <qstring.h>
#include <qfileinfo.h>
#include <qobject.h>
#include <qmessagebox.h>

#include <kprocess.h>
#include <kapp.h>
#include <klocale.h>
#include <kapp.h>

#include <iostream>

#include "rcdatei.h"

//Interface to mplayer only

class mplayerinterface : public QObject
{
    Q_OBJECT
public:
    mplayerinterface();
    ~mplayerinterface();
    void stop();
    void pause();
    int play(QString);
    void seekforward(int);
    void seekbackward(int);
    //This variables always hold the actual timevalues
    int maxtime;
    int actualtime;
    bool isplaying;
private:
    KProcess *playerProcess;
private slots:
    void getstatus(KProcess *,char *,int);
    void playerstopped(KProcess *);
signals:
    void playerstopped();
    void songlength(int);
    void songtime(int);
};

#endif //_MPLAYERINTERFACE_H_
