/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _TAGENGINEWRAPPER_H_
#define _TAGENGINEWRAPPER_H_

/*include the headers of all tagengines we want to use.
 *maybe i will support others later, so i think, it is the right decision to have a wrapper class*/
#include "taglib-interface.h"
#include "ogg-interface.h"
#include "libid3tag-interface.h"

#include "rcdatei.h"

/*This motherclass is the only one, we should call, when we want to handle mediafiles
 *It makes sure that we can use any other new implemented class the same way, cause the API can not always stay the same
 *in all of them. The differnet audio-formats don't have all supported possibilities in k-yamo
 *Also it easier to set things like used tagversion, if we have a master-class*/
 
class mediafile
{
public:
  mediafile(QString);
  ~mediafile();
  bool saveFile();
  void setTags(mediatag);
  void readTags();
  void readPicture();
  bool containsTag;
  bool isv2capable;//can we save v2tags to the file?
  bool picturepossible;//is there a chance to read out a picture?
  bool readsuccess;
  int bitrate;
  mediatag taginfo;
private:
  QString filename;
  int filetype;
  oggfile *fileogg;
  taglibfile *filetaglib;
  id3libfile *fileid3lib;
  //helperfunctions needed top get things going
  QString srtipUnwantedSpaces(QString);
};


#endif //_TAGENGINEWRAPPER_H_
