/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2009 Olivier Rolland <billl@users.sourceforge.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMRIP_OPTIONS_PLUGIN_H__
#define __OGMRIP_OPTIONS_PLUGIN_H__

#include <gmodule.h>

#include <gtk/gtkdialog.h>

#include <ogmrip-container.h>
#include <ogmrip-video-codec.h>
#include <ogmrip-audio-codec.h>
#include <ogmrip-subp-codec.h>

G_BEGIN_DECLS

/**
 * OGMRipVideoPreset:
 * @OGMRIP_VIDEO_PRESET_EXTREME: Extreme preset
 * @OGMRIP_VIDEO_PRESET_HIGH: High preset
 * @OGMRIP_VIDEO_PRESET_NORMAL: Normal preset
 * @OGMRIP_VIDEO_PRESET_USER: User defined preset
 *
 * Available video presets.
 */
typedef enum
{
  OGMRIP_VIDEO_PRESET_EXTREME,
  OGMRIP_VIDEO_PRESET_HIGH,
  OGMRIP_VIDEO_PRESET_NORMAL,
  OGMRIP_VIDEO_PRESET_USER
} OGMRipVideoPreset;

/**
 * OGMRipContainerOptionsPlugin:
 * @module: For internal use only
 * @dialog: The type of the dialog
 * @type: The type of the associated container
 * @set_options: The function that will propagate the options to the container
 *
 * A structure describing an options plugin for a container
 */

typedef struct _OGMRipContainerOptionsPlugin OGMRipContainerOptionsPlugin;

struct _OGMRipContainerOptionsPlugin
{
  GModule *module;
  /*< public >*/
  GType dialog;
  GType type;
  void (* set_options) (OGMRipContainer *container);
};

/**
 * OGMRipVideoOptionsPlugin:
 * @module: For internal use only
 * @dialog: The type of the dialog
 * @type: The type of the associated video codec
 * @set_options: The function that will propagate the options to the video codec
 *
 * A structure describing an options plugin for a video codec
 */

typedef struct _OGMRipVideoOptionsPlugin OGMRipVideoOptionsPlugin;

struct _OGMRipVideoOptionsPlugin
{
  GModule *module;
  /*< public >*/
  GType dialog;
  GType type;
  void (* set_options) (OGMRipVideoCodec  *video_codec);
};

/**
 * OGMRipAudioOptionsPlugin:
 * @module: For internal use only
 * @dialog: The type of the dialog
 * @type: The type of the associated video codec
 * @set_options: The function that will propagate the options to the video codec
 *
 * A structure describing an options plugin for a video codec
 */

typedef struct _OGMRipAudioOptionsPlugin OGMRipAudioOptionsPlugin;

struct _OGMRipAudioOptionsPlugin
{
  GModule *module;
  /*< public >*/
  GType dialog;
  GType type;
  void (* set_options) (OGMRipAudioCodec *codec);
};

/**
 * OGMRipSubpOptionsPlugin:
 * @module: For internal use only
 * @dialog: The type of the dialog
 * @type: The type of the associated video codec
 * @set_options: The function that will propagate the options to the video codec
 *
 * A structure describing an options plugin for a video codec
 */

typedef struct _OGMRipSubpOptionsPlugin OGMRipSubpOptionsPlugin;

struct _OGMRipSubpOptionsPlugin
{
  GModule *module;
  /*< public >*/
  GType dialog;
  GType type;
  void (* set_options) (OGMRipSubpCodec *codec);
};

void        ogmrip_options_plugin_init                    (void);
void        ogmrip_options_plugin_uninit                  (void);

gboolean    ogmrip_options_plugin_exists                  (GType             type);

GtkWidget * ogmrip_container_options_plugin_dialog_new    (GType             type,
                                                           const gchar       *profile);
void        ogmrip_container_options_plugin_set_options   (OGMRipContainer   *container);

GtkWidget * ogmrip_video_options_plugin_dialog_new        (GType             type,
                                                           const gchar       *profile);
void        ogmrip_video_options_plugin_set_options       (OGMRipVideoCodec  *codec);

GtkWidget * ogmrip_audio_options_plugin_dialog_new        (GType             type, 
                                                           const gchar       *profile);
void        ogmrip_audio_options_plugin_set_options       (OGMRipAudioCodec  *codec);

GtkWidget * ogmrip_subp_options_plugin_dialog_new         (GType             type,
                                                           const gchar       *profile);
void        ogmrip_subp_options_plugin_set_options        (OGMRipSubpCodec   *codec);

G_END_DECLS

#endif /* __OGMRIP_OPTIONS_PLUGIN_H__ */

