/* 
* Copyright (C) 2005, 2006 Liu Di <liudidi@gmail.com> 
*
* Copyright (C) 2007 Wei Lian <lianwei3@gmail.com>
*
* This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include "header.h"
#include <qlayout.h>

Config::Config (QWidget * parent, const char *name):
QDialog (parent, name, FALSE,
	 WStyle_Customize | WStyle_NormalBorder | WStyle_Title |
	 WStyle_SysMenu)
{
   QSettings settings;

   QVBoxLayout *vb = new QVBoxLayout (this, 2);
   vb->setAutoAdd (TRUE);

   QHBox *hbox = new QHBox (this);
   QLabel *label = new QLabel (tr ("Player (mp3):"), hbox);
   editplayer_mp3 =
      new QLineEdit (settings.
		     readEntry ("/qsopcast/player_mp3", "xmms"), hbox);
   hbox = new QHBox (this);
   label = new QLabel (tr ("Player (rm):"), hbox);
   editplayer_rm =
      new QLineEdit (settings.
		     readEntry ("/qsopcast/player_rm",
				"mplayer -ontop -geometry 100%:100%"), hbox);
   hbox = new QHBox (this);
   label = new QLabel (tr ("Player (wmv):"), hbox);
   editplayer_wmv =
      new QLineEdit (settings.
		     readEntry ("/qsopcast/player_wmv",
				"mplayer -ontop -geometry 100%:100%"), hbox);


   hbox = new QHBox (this);
   label = new QLabel (tr ("Channel URL:"), hbox);
   editchannelurl =
      new QLineEdit (settings.
		     readEntry ("/qsopcast/channelurl",
				"http://channel.sopcast.com/gchlxml"), hbox);

   hbox = new QHBox (this);
   label = new QLabel (tr ("sopcast URL header:"), hbox);
   editchannelheader =
      new QLineEdit (settings.
		     readEntry ("/qsopcast/channelheader", "sop://"), hbox);
   editchannelheader->setReadOnly (TRUE);


   hbox = new QHBox (this);
   label = new QLabel (tr ("Record directory:"), hbox);
   editrecorddir =
      new QLineEdit (settings.
		     readEntry ("/qsopcast/recorddir",
				QDir::homeDirPath () + "/SOPCAST/"), hbox);



   hbox = new QHBox (this);
   QPushButton *buttonclose = new QPushButton (tr ("Close"), hbox);
   QPushButton *buttonsave = new QPushButton (tr ("Save"), hbox);
   connect (buttonclose, SIGNAL (clicked ()), this, SLOT (close ()));
   connect (buttonsave, SIGNAL (clicked ()), this,
	    SLOT (onbuttonsaveclicked ()));

   adjustSize ();
   setMinimumWidth (350);

}

void
Config::onbuttonsaveclicked ()
{
   QSettings settings;
   settings.writeEntry ("/qsopcast/player_mp3", editplayer_mp3->text ());
   settings.writeEntry ("/qsopcast/player_rm", editplayer_rm->text ());
   settings.writeEntry ("/qsopcast/player_wmv", editplayer_wmv->text ());
   settings.writeEntry ("/qsopcast/channelurl", editchannelurl->text ());
   settings.writeEntry ("/qsopcast/channelheader",
			editchannelheader->text ());
   settings.writeEntry ("/qsopcast/recorddir", editrecorddir->text ());

   close ();
}
