/* 
* Copyright (C) 2005, 2006 Liu Di <liudidi@gmail.com> 
*
* Copyright (C) 2007 Wei Lian <lianwei3@gmail.com>
*
* This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "mypopupmenu.h"
#include "loadsave.h"
#include "mainwindow.h"
#include "menubar.h"
#include "channel.h"

LoadSave::LoadSave (MainWindow * parent):
mainwindow (parent)
{
   menubar = mainwindow->menubar;
   loadopenstate ();
   loadbookmark ();
}

LoadSave::~LoadSave ()
{
   saveopenstate ();
   savebookmark ();
}

//-----------------------------------------------------
void
LoadSave::loadbookmark ()
{
   ///assign initial value
   int id = 2;

   QFile fp (QDir::homeDirPath () + "/.qsopcast/bookmark");
   if (fp.open (IO_ReadOnly)) {
      QTextStream stream (&fp);
      stream.setEncoding (QTextStream::UnicodeUTF8);
      while (!stream.atEnd ()) {
	 menubar->bookmark->insertItem (stream.readLine (), id);
	 strlst += menubar->bookmark->text (id);
	 id++;
      }
      fp.close ();
   }
}

//-----------------------------------------------------
void
LoadSave::savebookmark ()
{
   ///test change
   bool flag = FALSE;
   if (strlst.count () == menubar->bookmark->count () - 2) {
      QStringList::Iterator it = strlst.begin ();
      int index = 2;
      while (it != strlst.end ()) {
	 if (menubar->bookmark->text (menubar->bookmark->idAt (index)) != *it) {
	    flag = TRUE;
	    break;
	 }
	 it++;
	 index++;
      }
   }
   else
      flag = TRUE;
   ///save bookmark
   if (flag == TRUE) {
      QFile fp (QDir::homeDirPath () + "/.qsopcast/bookmark");
      QDir dir (QDir::homeDirPath () + "/.qsopcast");
      if (!dir.exists ())
	 dir.mkdir (QDir::homeDirPath () + "/.qsopcast");
      if (fp.open (IO_WriteOnly)) {
	 QTextStream stream (&fp);
	 stream.setEncoding (QTextStream::UnicodeUTF8);

	 for (uint index = 2; index < menubar->bookmark->count (); index++)
	    stream << menubar->bookmark->text (menubar->bookmark->
					       idAt (index)) << endl;

	 fp.close ();
      }
   }
}

//-----------------------------------------------------
void
LoadSave::loadopenstate ()
{
   QFile fp (QDir::homeDirPath () + "/.qsopcast/tree");
   if (fp.open (IO_ReadOnly)) {
      char value;
      while (::read (fp.handle (), &value, 1)==1)
	 mainwindow->channel->stateopen.append (value);
      fp.close ();
   }
}


//-----------------------------------------------------
void
LoadSave::saveopenstate ()
{
   mainwindow->channel->updateOpenState ();

   QString data_path = QDir::homeDirPath () + "/.qsopcast/";
   QDir dir (data_path);
   if (!dir.exists ())
      dir.mkdir (data_path);
   data_path += "tree";

   QFile fp (data_path);
   if (fp.open (IO_WriteOnly)) {
      for (uint i = 0; i < mainwindow->channel->stateopen.count (); i++) {
	 char value = *(mainwindow->channel->stateopen.at (i));
	 ::write (fp.handle (), &value, 1);
      }
      fp.close ();
   }
   else
      perror ("path to file tree is invalid");
}

//-----------------------------------------------------
