/* 
* Copyright (C) 2005, 2006 Liu Di <liudidi@gmail.com> 
*
* Copyright (C) 2007 Wei Lian <lianwei3@gmail.com>
*
* This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "mylabel.h"
#include <qlistview.h>

MyLabel::MyLabel(QWidget * parent):
QLabel(parent, 0, WType_TopLevel | WX11BypassWM),
channel(static_cast < QListView * >(parent))
{
    setFrameStyle(QFrame::Plain | QFrame::Box);
    setPaletteBackgroundColor(QColor(255, 255, 230));
    setMouseTracking(TRUE);
}


void
 MyLabel::mouseMoveEvent(QMouseEvent * e)
{
    QPoint p(e->pos());
    QPoint pp(channel->mapFromGlobal(e->globalPos()));

    QRect pr(channel->rect());

    pr.setWidth(pr.width() -
		channel->verticalScrollBar()->width() *
		channel->verticalScrollBar()->isVisible());
    pr.setHeight(pr.height() -
		 channel->horizontalScrollBar()->height() *
		 channel->horizontalScrollBar()->isVisible());

    if (!rect().contains(p) && !pr.contains(pp))
	hide();

}
