
#ifndef MYLISTITEM_H
#define MYLISTITEM_H

#include <qlistview.h>

class MyListItem:public QListViewItem {
  public:
    MyListItem(QListView * parent):QListViewItem(parent) {
	bcolor = Qt::white;
	fcolor = Qt::black;
	state = 0;
    }
    MyListItem(QListViewItem * parent):QListViewItem(parent) {
	bcolor = Qt::white;
	fcolor = Qt::black;
	state = 0;
    }
  MyListItem(QListView * parent, QListViewItem * after):QListViewItem(parent, after)
    {
	bcolor = Qt::white;
	fcolor = Qt::black;
	state = 0;
    }
  MyListItem(QListViewItem * parent, QListViewItem * after):QListViewItem(parent, after)
    {
	bcolor = Qt::white;
	fcolor = Qt::black;
	state = 0;
    }

    QColor fcolor;
    QColor bcolor;
    int state;

  private:

    void paintCell(QPainter * p, const QColorGroup & cg,
		   int column, int width, int alignment) {
	QColorGroup _cg(cg);
//    QColor c = _cg.text ();
	_cg.setColor(QColorGroup::Base, bcolor);
	_cg.setColor(QColorGroup::Text, fcolor);

	QListViewItem::paintCell(p, _cg, column, width, alignment);
//    _cg.setColor (QColorGroup::Text, c);
    }

    int compare(int that, int other) const {
	if (that < other)
	    return -1;
	else if (that > other)
	    return 1;
	return 0;
    }
    int compare(QListViewItem * i, int col, bool ascending) const {
	switch (col) {
	case 1:
	case 3:
	case 4:
	case 5:
	case 6:
	case 7:
	    return compare(text(col).toInt(), i->text(col).toInt());
	    default:return QListViewItem::compare(i, col, ascending);
	}
    }
};


#endif
