/* 
* Copyright (C) 2005, 2006 Liu Di <liudidi@gmail.com> 
*
* Copyright (C) 2007 Wei Lian <lianwei3@gmail.com>
*
* This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "qapplication.h"
#include "mystatusbar.h"
#include "sopfork.h"
#include "pageplay.h"
#include "record.h"
#include "mainwindow.h"
#include "tabwidget.h"
#include <qlabel.h>

enum
{
   CONNECT,
   HOOK
};

MyStatusBar::MyStatusBar (QWidget * parent, const char *name):
QStatusBar (parent, name),
mainwindow (static_cast < MainWindow * >(parent))
{
   message_label[0] = new QLabel (this);
   addWidget (message_label[0], 1, 0);
   for (int i = 1; i < 6; i++) {
      message_label[i] = new QLabel (this);
      message_label[i]->hide ();
   }

   flag_state = CONNECT;
}

//-----------------------------------------------------------------
void
MyStatusBar::showMessage (QString str)
{
   if (flag_state == HOOK) {
      for (int i = 1; i < 6; i++) {
	 removeWidget (message_label[i]);
	 message_label[i]->hide ();
      }
      flag_state = CONNECT;
   }
   message_label[0]->setText (str);
}

void
MyStatusBar::showMessage (QString str[6])
{
   if (flag_state == CONNECT) {
      for (int i = 1; i < 6; i++) {
	 addWidget (message_label[i], 1, 0);
	 message_label[i]->show ();
      }
      flag_state = HOOK;
   }
   for (int i = 0; i < 6; i++)
      message_label[i]->setText (str[i]);

}

//-----------------------------------------------------------------
void
MyStatusBar::mousePressEvent (QMouseEvent *)
{
   SopFork *sopfork =
      static_cast < MyHBox * >(mainwindow->tabwidget->currentPage ())
      ->sopfork;

   if (sopfork)
      message (sopfork->channelname);
}

void
MyStatusBar::mouseReleaseEvent (QMouseEvent *)
{
   clear ();
}


void
MyStatusBar::leaveEvent (QEvent *)
{
   clear ();
}
