/* 
* Copyright (C) 2005, 2006 Liu Di <liudidi@gmail.com> 
*
* Copyright (C) 2007 Wei Lian <lianwei3@gmail.com>
*
* This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "header.h"
#include "mainwindow.h"
#include "menubar.h"
#include "channel.h"
#include "pageplay.h"
#include "tabwidget.h"
#include "playfork.h"
#include "sopfork.h"
#include "utils.h"
#include "mystatusbar.h"


PagePlay::PagePlay (QWidget * parent, const char *name):
MyHBox (parent, name),
tabwidget (static_cast < TabWidget * >(parent))
{
   ////row
   QToolButton *buttonlaunch = new QToolButton (this);
   buttonlaunch->setTextLabel (tr ("Launch"));
   buttonlaunch->setAutoRaise (true);
   buttonlaunch->setUsesTextLabel (true);
//    buttonlaunch->setMaximumSize(buttonplayer->sizeHint());
   connect (buttonlaunch, SIGNAL (clicked ()), this,
	    SLOT (onButtonLaunchClicked ()));

   buttonplayer = new QToolButton (this);
   buttonplayer->setTextLabel (tr ("Player"));
   buttonplayer->setAutoRaise (true);
   buttonplayer->setUsesTextLabel (true);
   buttonplayer->setToggleButton (TRUE);
//    buttonplayer->setMaximumSize(buttonplayer->sizeHint());
   connect (buttonplayer, SIGNAL (toggled (bool)), this,
	    SLOT (onButtonPlayerToggled (bool)));

   buttonstop = new QToolButton (this);
   buttonstop->setTextLabel (tr ("Stop"));
   buttonstop->setAutoRaise (true);
   buttonstop->setUsesTextLabel (true);
//    buttonstop->setMaximumSize(buttonstop->sizeHint());
   connect (buttonstop, SIGNAL (clicked ()), this,
	    SLOT (onButtonStopClicked ()));

   QToolButton *but = new QToolButton (this);
   but->setTextLabel (tr ("x"));
   but->setAutoRaise (true);
   but->setUsesTextLabel (true);
   but->setMaximumSize (but->sizeHint ());
   connect (but, SIGNAL (clicked ()), this, SLOT (removeTab ()));


   playfork = new PlayFork (this);
   ///initialize flagMenu
   flagMenu = false;

}

PagePlay::~PagePlay ()
{
   ///make sure playfork is deleted before executing detachSop 
   buttonplayer->setOn (false);	///killPlayer
//   playfork->killPlayer();
   ///WARNING: here tabwidget should not be substituted by parentWidget()
   ///because parentWidget() will lose infor during destruction 
   tabwidget->detachSop (&sopfork, this);
}

void
PagePlay::onButtonStopClicked ()
{
   playfork->killPlayer ();
   tabwidget->detachSop (&sopfork, this);
   ///assign channel name to tab label
   tabwidget->setTabLabel (this, tr ("play"));
   ///clean statusbar
   static_cast < MainWindow * >(qApp->mainWidget ())
      ->statusbar->showMessage ("");
}

void
PagePlay::onButtonPlayerToggled (bool t)
{
   if (t) {
      if (sopfork && sopfork->snstatus && !playfork->player->isRunning ()) {
	 if (playfork->forkPlayer () == TRUE)
	    buttonplayer->setPaletteForegroundColor (Qt::blue);
	 else
	    fprintf (stderr, "failed to launch player!\n");
      }
   }
   else
      playfork->killPlayer ();
}

void
PagePlay::removeTab ()
{
   ///only one tab remained
   if (tabwidget->count () == 1)
      return;

   tabwidget->removePage (this);
   delete this;
}


void
PagePlay::onButtonLaunchClicked ()
{
   if (!flagMenu) {
      channelurl = static_cast < MainWindow * >(qApp->mainWidget ())
	 ->editsearch->text ();
      ///editsearch has focus and is a valid Sop URL
      if (static_cast < MainWindow * >(qApp->mainWidget ())
	  ->editsearch->hasFocus () &&
	  static_cast < MainWindow * >(qApp->mainWidget ())
	  ->channel->SopMatch (channelurl, channelname, channeltype)) {
      }
      else {
	 ///editsearch has no focus
	 QListViewItem *item =
	    static_cast < MainWindow * >(qApp->mainWidget ())
	    ->channel->currentItem ();
	 ///test channel item validity
	 if (!item || item->depth () != 1) {
	    return;
	 }
	 channelurl = item->text (URL_COLUMN);
	 channelname = item->text (NAME_COLUMN);
	 channeltype = item->text (STREAM_COLUMN);
      }
   }
   /////stop previous channel
   playfork->killPlayer ();
   tabwidget->detachSop (&sopfork, this);
   ////start new channel
   if (tabwidget->
       attachSop (&sopfork, this, channelurl, channelname, channeltype)
       == TRUE) {
      ///start player
      if (buttonplayer->isOn ())
	 onButtonPlayerToggled (true);
      ///assign channel name to tab label
      tabwidget->setTabLabel (this, reduceLabelLength (channelname));
      ///show message on statusbar
      static_cast < MainWindow * >(qApp->mainWidget ())
	 ->statusbar->showMessage (tr ("Connecting..."));
      ///add to history
      static_cast < MainWindow * >(qApp->mainWidget ())
	 ->menubar->addToPopupMenu (static_cast < MainWindow * >
				    (qApp->mainWidget ())->
				    menubar->history,
				    channelurl, channelname, channeltype);
   }
   else
      fprintf (stderr, "failed to launch sp-sc!\n");
}
