/* 
* Copyright (C) 2005, 2006 Liu Di <liudidi@gmail.com> 
*
* Copyright (C) 2007 Wei Lian <lianwei3@gmail.com>
*
* This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "header.h"
#include "sopfork.h"
#include "playfork.h"
#include "config.h"
#include "pageplay.h"
#include "mainwindow.h"
#include "menubar.h"
#include "utils.h"
#include "tabwidget.h"

PlayFork::PlayFork (QWidget * parent, const char *name):
QObject (parent, name),
pageplay (static_cast < PagePlay * >(parent))
{
   ///player process
   player = new QProcess (this);
   connect (player, SIGNAL (processExited ()), this, SLOT (onPlayerExit ()));
}


PlayFork::~PlayFork ()
{
}


////fork new process
bool
PlayFork::forkPlayer ()
{
   player->clearArguments ();
   ////
   QString playerparameter;
   if (pageplay->sopfork->channeltype == "mp3")
      playerparameter = static_cast < MainWindow * >(qApp->mainWidget ())
	 ->vboxconfig->editplayer_mp3->text ();
   else if (pageplay->sopfork->channeltype == "rm")
      playerparameter = static_cast < MainWindow * >(qApp->mainWidget ())
	 ->vboxconfig->editplayer_rm->text ();
   else
      playerparameter = static_cast < MainWindow * >(qApp->mainWidget ())
	 ->vboxconfig->editplayer_wmv->text ();
   ////
   QStringList strlst = QStringList::split (" ", playerparameter);
   for (QStringList::Iterator it = strlst.begin (); it != strlst.end (); ++it) {
      player->addArgument (*it);
   }
   ////
   QString url = "http://127.0.0.1:";
   url += pageplay->sopfork->outport;
   player->addArgument (url);
   return player->start ();
}


////should be executed before executing detachSop, otherwise may fail
void
PlayFork::killPlayer ()
{
   ///FIXME: sometimes fails to kill
//   if (!player->isRunning ())
//      return;
   ///
   if (!pageplay->sopfork)
      return;

   ///the following code should be called before destructing TabWidget?
   ///find process id scope
   long idmin = player->processIdentifier () + 20;
   for (QWidget * wd = pageplay->sopfork->listpage.first (); wd;
	wd = pageplay->sopfork->listpage.next ())
      ///outdated: WARNING: here tabwidget should not be 
      ///substituted by parentWidget(),
      ///because parentWidget() will lose infor during destruction 
      if (static_cast < MyHBox * >(wd)->pagetype == "play") {
	 QProcess *proc = static_cast < PagePlay * >(wd)
	    ->playfork->player;
	 if (proc->isRunning ()
	     && proc->processIdentifier () > player->processIdentifier ()
	     && proc->processIdentifier () < idmin)
	    idmin = proc->processIdentifier ();
      }

   //kill all process within the scope
   char playerUrl[64] = "http://127.0.0.1:";
   strcat (playerUrl, pageplay->sopfork->outport);
   killProcess (playerUrl, player->processIdentifier (), idmin);
}


/////////////slots
void
PlayFork::onPlayerExit ()
{
   ///restore button player color to black
   pageplay->buttonplayer->setPaletteForegroundColor (Qt::black);
   ///restart player
   if (pageplay->buttonplayer->isOn ())
      if (static_cast < MainWindow * >(qApp->mainWidget ())->
	  menubar->menu_config->isItemChecked (AUTO_RESTART_PLAYER))
	 pageplay->onButtonPlayerToggled (true);
      else
	 pageplay->buttonplayer->setOn (false);
}
