/* 
* Copyright (C) 2005, 2006 Liu Di <liudidi@gmail.com> 
*
* Copyright (C) 2007 Wei Lian <lianwei3@gmail.com>
*
* This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "header.h"
#include "tabwidget.h"
#include "record.h"
#include "pageplay.h"
#include "mytabbar.h"
#include "sopfork.h"
#include "mainwindow.h"
#include "mystatusbar.h"

TabWidget::TabWidget (QWidget * parent, const char *name):
QTabWidget (parent, name)
{
   ///use custom  tabbar
   tabbar = new MyTabBar (this);
   setTabBar (tabbar);
   ///topleft corner widget
   QToolButton *but = new QToolButton (this);
   but->setTextLabel ("p");
   but->setAutoRaise (true);
   but->setUsesTextLabel (true);
   setCornerWidget (but, Qt::TopLeft);
   connect (but, SIGNAL (clicked ()), this, SLOT (insertPlayTab ()));
   ///topright corner widget
   but = new QToolButton (this);
   but->setTextLabel ("r");
   but->setAutoRaise (true);
   but->setUsesTextLabel (true);
   setCornerWidget (but, Qt::TopRight);
   connect (but, SIGNAL (clicked ()), this, SLOT (insertRecordTab ()));
   ///tab play
   PagePlay *pageplay = new PagePlay (this);
   addTab (pageplay, tr ("play"));
   showPage (pageplay);

   setMaximumHeight (sizeHint ().height ());
   ///page change signal
   connect (this, SIGNAL (currentChanged (QWidget *)), this,
	    SLOT (onCurrentChanged (QWidget *)));

   ///autodelete the item 
//   listsopfork.setAutoDelete( TRUE ); //failed, why?
}


TabWidget::~TabWidget ()
{
}


void
TabWidget::addPlayTab ()
{
   PagePlay *pageplay = new PagePlay (this);
   addTab (pageplay, tr ("play"));
   showPage (pageplay);
}


void
TabWidget::insertPlayTab ()
{
   PagePlay *pageplay = new PagePlay (this);
   insertTab (pageplay, tr ("play"), currentPageIndex () + 1);
   showPage (pageplay);
}


void
TabWidget::addRecordTab ()
{
   Record *record = new Record (this);
   addTab (record, tr ("record"));
   showPage (record);
}


void
TabWidget::insertRecordTab ()
{
   Record *record = new Record (this);
   insertTab (record, tr ("record"), currentPageIndex () + 1);
   showPage (record);
}


void
TabWidget::mouseDoubleClickEvent (QMouseEvent * e)
{
   QPoint p (e->pos ());
   QRect pr (rect ());
   pr.setHeight (tabbar->height ());
   //mouse stay outside of tabbar area
   if (!pr.contains (p))
      return;

   if (e->button () == QMouseEvent::LeftButton)
      addPlayTab ();
   else if (e->button () == QMouseEvent::RightButton)
      addRecordTab ();
}


void
TabWidget::onCurrentChanged (QWidget * current)
{
   SopFork *sopfork;
   sopfork = static_cast < MyHBox * >(current)->sopfork;

   if (!sopfork)
      static_cast < MainWindow * >(qApp->mainWidget ())
	 ->statusbar->showMessage ("");
   else if (sopfork->message != "data")
      static_cast < MainWindow * >(qApp->mainWidget ())
	 ->statusbar->showMessage (sopfork->message);
   else
      static_cast < MainWindow * >(qApp->mainWidget ())
	 ->statusbar->showMessage (sopfork->arraymessage);
}


///attach Sop
bool
   TabWidget::attachSop (SopFork ** sopfork, QWidget * widget, QString url,
			 QString name, QString type)
{
   bool found = false;
   ///if found a sop with the same url, just register it 
   for (SopFork * sf = listsopfork.first (); sf; sf = listsopfork.next ())
      if (sf->channelurl == url) {
	 ///assign value to pointer
	 *sopfork = sf;
	 (*sopfork)->listpage.append (widget);
	 ///
	 found = true;
	 break;
      }
   ///if not found, fork new sop
   if (found == false) {
      ///widget is added to sopfork's listpage list while initializing sopfork
      listsopfork.append (new SopFork (widget, url, name, type, this));
      ///assign value to pointer
      *sopfork = listsopfork.current ();
//      (*sopfork)->listpage.append (widget);
   }
//   printf ("sopfork count=%d\n", listsopfork.count ());
//   printf ("pageplay count=%d\n", (*sopfork)->listpage.count ());
   return true;
}


///detach Sop
void
TabWidget::detachSop (SopFork ** sopfork, QWidget * widget)
{
   if (*sopfork == NULL)
      return;

   bool found = false;
   ///list refers to a list of Page
   for (QWidget * wd = (*sopfork)->listpage.first (); wd;
	wd = (*sopfork)->listpage.next ())
      if (wd == widget) {
	 (*sopfork)->listpage.remove (wd);
	 ///if sop's pageplay list is empty
	 if ((*sopfork)->listpage.isEmpty ()) {
	    ///remove item from list
	    listsopfork.remove (*sopfork);
	    ///delete item
	    delete *sopfork;
	 }
	 *sopfork = NULL;
	 found = true;
	 break;
      }

   if (found == false)
      perror ("not found");
}
