/* 
* Copyright (C) 2005, 2006 Liu Di <liudidi@gmail.com> 
*
* Copyright (C) 2007 Wei Lian <lianwei3@gmail.com>
*
* This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <qvalidator.h>
#include "timing.h"
#include "header.h"

Timing::Timing(QWidget * parent, const char *name):QHBox(parent, name)
{
    //validator  
    QRegExp rxhour("2[0-3]|1?\\d"), rxminute("[1-5]?\\d");
    QRegExpValidator *valHour = new QRegExpValidator(rxhour, this);
    QRegExpValidator *valMinute = new QRegExpValidator(rxminute, this);
    ////lineedit
    label_timing = new QLabel(tr(" Timing(hour:minute) "), this);
    fromHour = new QLineEdit(this);
    fromHour->setValidator(valHour);
    new QLabel(" : ", this);
    fromMinute = new QLineEdit(this);
    fromMinute->setValidator(valMinute);
    new QLabel(" -- ", this);
    toHour = new QLineEdit(this);
    toHour->setValidator(valHour);
    new QLabel(" : ", this);
    toMinute = new QLineEdit(this);
    toMinute->setValidator(valMinute);

}
