/***************************************************************************
					alsasound.h  -  description
						 -------------------
		begin                : Wed Jul 5 2000
		copyright            : (C) 2000 by Jozef Kosoru
		email                : jozef.kosoru@pobox.sk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ALSASOUND_H
#define ALSASOUND_H

#define ALSA_PCM_NEW_HW_PARAMS_API
#include <alsa/asoundlib.h>
#include <iostream>
#include <stdexcept>
#include <string>
#include <new>

class TunerOptions;

/**
 *	@author Jozef Kosoru
 */
class AlsaSound
{
public:
	AlsaSound(TunerOptions* pOptions) throw(std::runtime_error, std::bad_alloc);

	~AlsaSound();

	static void fillDeviceList(TunerOptions* pOptions) throw(std::runtime_error, std::bad_alloc);

	void capture() throw (std::runtime_error)
	{
		snd_pcm_sframes_t iErr;
		if ((iErr = snd_pcm_readi(m_pcm_handle, m_pAudioBuffer, m_iBufferSize)) < 0)
		{
			if (iErr == -EPIPE)
			{
				// overrun occured
#ifdef _DEBUG
				std::cerr << "[AlsaSound::capture()] overrun" << std::endl;
#endif
				if ((iErr = snd_pcm_prepare(m_pcm_handle)) < 0)
				{
					std::runtime_error("ALSA error: Cannot prepare audio interface for use.");
				}
			}
			else
			{
//                std::cerr << "iErr = " << iErr << "\tsnd_error: " << snd_strerror(iErr)
//							<< std::endl;
				throw std::runtime_error("ALSA error: Cannot record samples from the audio device");
			}
		}
	}

private:
	std::string m_sPcmName;

	snd_pcm_t* m_pcm_handle;

	char* m_pAudioBuffer;
	snd_pcm_uframes_t m_iBufferSize;

	TunerOptions* m_pOptions;
};

#endif
