/***************************************************************************
					optionsdialog.cpp  -  description
						 -------------------
		begin                : Mon Jul 10 2000
		copyright            : (C) 2000 by Jozef Kosoru
		email                : jozef.kosoru@pobox.sk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "control.h"
#include <cstdlib>
#include <qvbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qlayout.h>
#include <qstringlist.h>
#include <qstring.h>
#include <stdlib.h>
#include <qspinbox.h>
#include <qslider.h>
#include <qvalidator.h>
#include <qwhatsthis.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <klocale.h>
#include <kiconloader.h>
#include "optionsdialog.h"
#include "tuneroptions.h"
#include "tonedetermine.h"
#include "tuneroid.h"
#include "alsasound.h"
#include "threadengine.h"
#include "tunerdisplay.h"

OptionsDialog::OptionsDialog(QWidget* parent, const char* name)
 : KDialogBase(KDialogBase::IconList, i18n("Settings"),
			   KDialogBase::Ok|KDialogBase::Apply|KDialogBase::Cancel|KDialogBase::Default,
			   KDialogBase::Ok, parent, name, true, true)
{
	Tuneroid* const tuneroid = static_cast<Tuneroid*>(parent);
	m_options = tuneroid->getTunerOptions();
	m_toneDetermine = tuneroid->getToneDetermine();

	initTab1();
	initTab2();

	loadSettings();
}

OptionsDialog::~OptionsDialog()
{

}

QSize OptionsDialog::minimumSizeHint() const
{
	QSize size = KDialogBase::minimumSizeHint();
	size.setWidth(static_cast<int>(size.width() * 1.2));
	return size;
}

void OptionsDialog::initTab1()
{
	QFrame* const tab1 = addPage(i18n("Audio"), i18n("Audio settings"),
								 BarIcon("kcmpci", KIcon::SizeLarge));

	QGridLayout* const topLayout = new QGridLayout(tab1, 8, 4, marginHint(), spacingHint());

	QLabel* const deviceLabel = new QLabel(i18n("Ca&rd:"), tab1);
	deviceLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
	topLayout->addWidget(deviceLabel, 0, 0);
	m_deviceCombo = new QComboBox(false, tab1);
	m_deviceCombo->insertStringList(getDeviceList());
	deviceLabel->setBuddy(m_deviceCombo);
	QWhatsThis::add(m_deviceCombo, i18n("Select the sound card"));
	topLayout->addMultiCellWidget(m_deviceCombo, 0, 0, 1, 3);

	QLabel* const subdeviceLabel = new QLabel(i18n("D&evice:"), tab1);
	subdeviceLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
	topLayout->addWidget(subdeviceLabel, 1, 0);
	m_subdeviceSpinBox = new QSpinBox(tab1);
	subdeviceLabel->setBuddy(m_subdeviceSpinBox);
	topLayout->addWidget(m_subdeviceSpinBox, 1, 1);

	m_setPcmNameCheckBox = new QCheckBox(i18n("Set &PCM name"), tab1);
	topLayout->addMultiCellWidget(m_setPcmNameCheckBox, 2, 2, 0, 3);
	connect(m_setPcmNameCheckBox, SIGNAL(toggled(bool)), deviceLabel, SLOT(setDisabled(bool)));
	connect(m_setPcmNameCheckBox, SIGNAL(toggled(bool)), m_deviceCombo, SLOT(setDisabled(bool)));
	connect(m_setPcmNameCheckBox, SIGNAL(toggled(bool)), subdeviceLabel, SLOT(setDisabled(bool)));
 	connect(m_setPcmNameCheckBox, SIGNAL(toggled(bool)), m_subdeviceSpinBox, SLOT(setDisabled(bool)));

	QLabel* const pcmNameLabel = new QLabel(i18n("PCM &name:"), tab1);
	pcmNameLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
	topLayout->addWidget(pcmNameLabel, 3, 0);
	m_pcmNameLineEdit = new QLineEdit(tab1);
    pcmNameLabel->setBuddy(m_pcmNameLineEdit);
	topLayout->addMultiCellWidget(m_pcmNameLineEdit, 3, 3, 1, 3);
 	connect(m_setPcmNameCheckBox, SIGNAL(toggled(bool)), pcmNameLabel, SLOT(setEnabled(bool)));
 	connect(m_setPcmNameCheckBox, SIGNAL(toggled(bool)), m_pcmNameLineEdit, SLOT(setEnabled(bool)));

	QLabel* const resolutionLabel = new QLabel(i18n("Resolutio&n:"), tab1);
	resolutionLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
	topLayout->addWidget(resolutionLabel, 4, 0);
	m_resolutionCombo = new QComboBox(false, tab1);
	m_resolutionCombo->insertItem("8");
	m_resolutionCombo->insertItem("16");
	resolutionLabel->setBuddy(m_resolutionCombo);
	topLayout->addWidget(m_resolutionCombo, 4, 1);
	QLabel* const bitLabel = new QLabel(i18n("bit"), tab1);
	bitLabel->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
	topLayout->addWidget(bitLabel, 4, 2);

	QLabel* const samplerateLabel = new QLabel(i18n("&Sampling Rate:"), tab1);
	samplerateLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
	topLayout->addWidget(samplerateLabel, 5, 0);
	m_samplerateCombo = new QComboBox(true, tab1);
	m_samplerateCombo->insertItem("11025");
	m_samplerateCombo->insertItem("22050");
	m_samplerateCombo->insertItem("44100");
	samplerateLabel->setBuddy(m_samplerateCombo);
	topLayout->addMultiCellWidget(m_samplerateCombo, 5, 5, 1, 2);
	QLabel* const hzLabel = new QLabel(i18n("Hz"), tab1);
	hzLabel->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
	topLayout->addWidget(hzLabel, 5, 3);

	QLabel* const responseLabel = new QLabel(i18n("Response &time:"), tab1);
	responseLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
	topLayout->addWidget(responseLabel, 6, 0);
	m_responseSpinBox = new QSpinBox(tab1);
	responseLabel->setBuddy(m_responseSpinBox);
	topLayout->addWidget(m_responseSpinBox, 6, 1);
	QLabel* const msLabel = new QLabel(i18n("ms"), tab1);
	msLabel->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
	topLayout->addWidget(msLabel, 6, 2);

	topLayout->setColStretch(0, 5);//5
	topLayout->setColStretch(1, 2);//2
	topLayout->setColStretch(2, 2);//2
	topLayout->setColStretch(3, 5);//5

	topLayout->setRowStretch(7, 10);

	// explicitly show this page (workaround for the kdelibs 3.x bug)
	showPage(pageIndex(tab1));
}

QStringList OptionsDialog::getDeviceList()
{
	QStringList deviceList;
	for (std::vector<TunerOptions::DeviceEntry>::const_iterator
							iter = m_options->m_deviceList.begin(),
							itEnd = m_options->m_deviceList.end();
		 iter != itEnd; ++iter)
	{
		deviceList.append(QString::fromLatin1(iter->sCardName.c_str()));
	}
	return deviceList;
}

void OptionsDialog::initTab2()
{
	QFrame* const tab2 = addPage(i18n("Tuner"), i18n("Tuner settings"),
								 BarIcon("package_settings", KIcon::SizeLarge));

	QGridLayout* const topLayout = new QGridLayout(tab2, 8, 4, marginHint(), spacingHint());

	QLabel* const freqOfALabel = new QLabel(i18n("&Frequency of A:"), tab2);
	freqOfALabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
	topLayout->addWidget(freqOfALabel, 0, 0);
	m_freqOfASpinBox = new QSpinBox(tab2);
	freqOfALabel->setBuddy(m_freqOfASpinBox);
	topLayout->addWidget(m_freqOfASpinBox, 0, 1);
	QLabel* const hzLabel = new QLabel(i18n("Hz"), tab2);
	hzLabel->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
	topLayout->addWidget(hzLabel, 0, 2);

	QLabel* const calibrateLabel = new QLabel(i18n("Cali&bration:"), tab2);
	calibrateLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
	topLayout->addWidget(calibrateLabel, 1, 0);
	m_calibrateSpinBox = new QSpinBox(tab2);
	calibrateLabel->setBuddy(m_calibrateSpinBox);
	topLayout->addWidget(m_calibrateSpinBox, 1, 1);

	QLabel* maxFreqLabel = new QLabel(i18n("&Max Frequency:"), tab2);
	maxFreqLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
	topLayout->addWidget(maxFreqLabel, 2, 0);
	m_maxFreqSpinBox = new QSpinBox(tab2);
	maxFreqLabel->setBuddy(m_maxFreqSpinBox);
	topLayout->addMultiCellWidget(m_maxFreqSpinBox, 2, 2, 1, 2);
	QLabel* const hzLabel2 = new QLabel(i18n("Hz"), tab2);
	hzLabel2->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
	topLayout->addWidget(hzLabel2, 2, 3);

	QLabel* const minFreqLabel = new QLabel(i18n("Mi&n Frequency:"), tab2);
	minFreqLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
	topLayout->addWidget(minFreqLabel, 3, 0);
	m_minFreqSpinBox = new QSpinBox(tab2);
	minFreqLabel->setBuddy(m_minFreqSpinBox);
	topLayout->addMultiCellWidget(m_minFreqSpinBox, 3, 3, 1, 2);
	QLabel* const hzLabel3 = new QLabel(i18n("Hz"), tab2);
	hzLabel3->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
	topLayout->addWidget(hzLabel3, 3, 3);

	topLayout->addRowSpacing(5, 5);
	topLayout->setRowStretch(5, 0);
	QLabel* const sensitivityLabel = new QLabel(i18n("&Sensitivity:"), tab2);
	sensitivityLabel->setAlignment(Qt::AlignCenter);
	topLayout->addMultiCellWidget(sensitivityLabel, 5, 5, 0, 3);

	QWidget* const sensitWidget = new QWidget(tab2);
	QHBoxLayout* const sensitLay = new QHBoxLayout(sensitWidget, 0, 5);
	QLabel* const dbLabel = new QLabel(i18n("high"), sensitWidget);
	sensitLay->addWidget(dbLabel, 0);
	m_sensitivitySlider = new QSlider(QSlider::Horizontal, sensitWidget);
	m_sensitivitySlider->setTickmarks(QSlider::Below);
	sensitivityLabel->setBuddy(m_sensitivitySlider);
	sensitLay->addWidget(m_sensitivitySlider, 10);
	QLabel* const dbLabel2 = new QLabel(i18n("low"), sensitWidget);
	sensitLay->addWidget(dbLabel2, 0);
	topLayout->addMultiCellWidget(sensitWidget, 6, 6, 0, 3);

	topLayout->setColStretch(0, 5);
	topLayout->setColStretch(1, 2);
	topLayout->setColStretch(2, 2);
	topLayout->setColStretch(3, 5);

	topLayout->setRowStretch(7, 10);
}

void OptionsDialog::loadSettings()
{
	int curCard;
	for (curCard = 0; curCard < int(m_options->m_deviceList.size()); ++curCard)
	{
		if (m_options->m_deviceList[curCard].iCardNumber == m_options->m_iCardNumber)
		{
			break;
		}
	}

	m_deviceCombo->setCurrentItem(curCard);

	m_subdeviceSpinBox->setMaxValue(m_options->m_deviceList[curCard].iDevicesCount - 1);
	m_subdeviceSpinBox->setMinValue(0);
	m_subdeviceSpinBox->setLineStep(1);
	m_subdeviceSpinBox->setValue(m_options->m_iDeviceNumber);

    // set state two times to ensure that 'toggled' signal is emited
    m_setPcmNameCheckBox->setChecked(!m_options->m_bUsePcmString);
    m_setPcmNameCheckBox->setChecked(m_options->m_bUsePcmString);

    m_pcmNameLineEdit->setText(QString::fromLatin1(m_options->m_sPcmName.c_str()));

	m_resolutionCombo->setCurrentItem((m_options->m_iResolution == 8) ? 0 : 1);

	m_samplerateCombo->setInsertionPolicy(QComboBox::NoInsertion);
	QIntValidator* const intValidator = new QIntValidator(8000, 100000, this);
	m_samplerateCombo->setValidator(intValidator);
	setCurrentSamplerateItem(m_samplerateCombo);

	m_responseSpinBox->setMaxValue(350);
	m_responseSpinBox->setMinValue(150);
	m_responseSpinBox->setLineStep(10);
	m_responseSpinBox->setValue(m_options->m_iBufferTime);

	m_freqOfASpinBox->setMaxValue(550);
	m_freqOfASpinBox->setMinValue(350);
	m_freqOfASpinBox->setLineStep(1);
	m_freqOfASpinBox->setValue(static_cast<int>(m_options->m_freqOf_A));

	m_calibrateSpinBox->setMaxValue(10);
	m_calibrateSpinBox->setMinValue(-10);
	m_calibrateSpinBox->setLineStep(1);
	m_calibrateSpinBox->setValue(getIntCalibrationValue(m_options->m_calibration));

	m_maxFreqSpinBox->setMaxValue(20000);
	m_maxFreqSpinBox->setMinValue(600);
	m_maxFreqSpinBox->setLineStep(100);
	m_maxFreqSpinBox->setValue(m_options->m_maxFreq);

	m_minFreqSpinBox->setMaxValue(500);
	m_minFreqSpinBox->setMinValue(20);
	m_minFreqSpinBox->setLineStep(10);
	m_minFreqSpinBox->setValue(m_options->m_minFreq);

	m_sensitivitySlider->setMaxValue(100);
	m_sensitivitySlider->setMinValue(0);
	m_sensitivitySlider->setLineStep(1);
	m_sensitivitySlider->setTickInterval(10);
	m_sensitivitySlider->setValue(getSliderSensitivityValue(m_options->m_threshold));
#ifdef _DEBUG_OD
	debug("Value: %d", getSliderSensitivityValue(m_options->m_threshold));
#endif
}

void OptionsDialog::setCurrentSamplerateItem(QComboBox* samplerateCombo)
{
	int curItem;
	switch (m_options->m_iSamplerate_real)
	{
		case 44100: curItem = 2; break;
		case 22050: curItem = 1; break;
		case 11025: curItem = 0; break;
		default: curItem = -1; break;
	}

	if (curItem == -1)
	{
		samplerateCombo->insertItem(QString("%1").arg(m_options->m_iSamplerate_real));
		samplerateCombo->setCurrentItem(samplerateCombo->count() - 1);
	}
	else
	{
		samplerateCombo->setCurrentItem(curItem);
	}
}

void OptionsDialog::slotOk()
{
	slotApply();
	KDialogBase::slotOk();
}

void OptionsDialog::slotApply()
{
	Tuneroid* const tuneroid = static_cast<Tuneroid*>(parent());
	ThreadEngine* const engine = tuneroid->getThreadEngine();
	TunerDisplay* const display = tuneroid->getDisplay();
	engine->stopThread();
	display->resetDisplay();

	//QSlider doesn't give last value if it has keyboard focus
	setFocus();

	m_options->m_iCardNumber = m_options->m_deviceList[m_deviceCombo->currentItem()].iCardNumber;
	m_options->m_iDeviceNumber = m_subdeviceSpinBox->value();

    m_options->m_bUsePcmString = m_setPcmNameCheckBox->isChecked();
    m_options->m_sPcmName = m_pcmNameLineEdit->text().latin1();

	m_options->m_iResolution = m_resolutionCombo->currentText().toInt();
	m_options->m_iSamplerate = m_samplerateCombo->currentText().toInt();

	if (m_options->m_iSamplerate > 100000)
	{
		 m_options->m_iSamplerate = 100000;
	}
	else if (m_options->m_iSamplerate < 8000)
	{
		 m_options->m_iSamplerate = 8000;
	}

	m_options->m_iBufferTime = m_responseSpinBox->value();
	m_options->m_freqOf_A = m_freqOfASpinBox->value();
	m_options->m_calibration = getFloatCalibrationValue(m_calibrateSpinBox->value());
#ifdef _DEBUG_OD
	std::cerr << "Calibration: " << m_options->m_calibration << endl;
#endif

	m_options->m_maxFreq = m_maxFreqSpinBox->value();
#ifdef _DEBUG_OD
	std::cerr << "Max Freq: " << m_maxFreqSpinBox->value() << std::endl;
#endif

	m_options->m_minFreq = m_minFreqSpinBox->value();
	m_options->m_threshold = getThresholdSensitivityValue(m_sensitivitySlider->value());
#ifdef _DEBUG_OD
	std::cerr << "Threshold: " << getThresholdSensitivityValue(m_sensitivitySlider->value())
			  << std::endl;
	std::cerr << "Slider: " <<  m_sensitivitySlider->value() << std::endl;
#endif
	m_toneDetermine->setNewFreqOf_A(m_options);

	engine->startThread();
}

void OptionsDialog::slotDefault()
{
	m_deviceCombo->setCurrentItem(m_options->m_deviceList[0].iCardNumber);
	m_subdeviceSpinBox->setValue(0);

	m_setPcmNameCheckBox->setChecked(true);
    m_pcmNameLineEdit->setText(QString::fromLatin1("default"));
	
	m_resolutionCombo->setCurrentItem(1);
	m_samplerateCombo->setCurrentItem(2);
	m_responseSpinBox->setValue(250);
	m_freqOfASpinBox->setValue(440);
	m_calibrateSpinBox->setValue(0);
	m_maxFreqSpinBox->setValue(20000);
	m_minFreqSpinBox->setValue(20);
	m_sensitivitySlider->setValue(50);
}
