/***************************************************************************
					tuneroid.cpp  -  description
						 -------------------
		begin                : Fri Feb 4 2000
		copyright            : (C) 2000 by Jozef Kosoru
		email                : jozef.kosoru@pobox.sk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "control.h"
#include <iostream>
#include <stdexcept>
#include <qevent.h>
#include <kmessagebox.h>
#include <ktoolbar.h>
#include <klocale.h>
#include <kaboutapplication.h>
#include "tunerdisplay.h"
#include "tuneroid.h"
#include "tuneroptions.h"
#include "tonedetermine.h"
#include "optionsdialog.h"

Tuneroid::Tuneroid()
 : KMainWindow()
{
	// read options
	m_options = new TunerOptions;

	// tool bar
	initToolBar();

	// main view
	m_lcdDisplay = new TunerDisplay(this);
	setCentralWidget(m_lcdDisplay);

	m_toneDetermine = new ToneDetermine(m_options);

	// start working thread
	initEngine();

	// next two lines try to fix an bug in KDE-libs (1.91 Beta)
	setFixedSize(sizeHint());
}

Tuneroid::~Tuneroid()
{
#ifdef _DEBUG
	std::cerr << "Tuneroid delete..." << std::endl;
#endif

	delete m_options;
	delete m_toneDetermine;
	delete m_engine;
}

void Tuneroid::slotOptions()
{
	OptionsDialog options(this);
	options.exec();
}

void Tuneroid::slotFrom_File()
{
	KMessageBox::sorry(this, i18n("Not implemented yet!"));
}

void Tuneroid::initToolBar()
{
	// toolbar
	toolBar()->setIconText(KToolBar::IconTextRight,false);
	toolBar()->setBarPos(KToolBar::Bottom);
	toolBar()->setEnableContextMenu(false);

	// toolbar moving cannot be disabled because of bug in the kdelibs (looks ugly then)
	//toolBar()->enableMoving(false);

#if 0
	// action-from_file
	toolBar()->insertButton("tuneroid-from_file", 1, SIGNAL(clicked()),
							this, SLOT(slotFrom_File()), true, i18n("File"));

#endif

	// action-options
	toolBar()->insertButton("package_settings", 2, SIGNAL(clicked()),
							this, SLOT(slotOptions()), true, i18n("Settings"));
	toolBar()->alignItemRight(2,true);
	toolBar()->insertButton("tuneroid", 3, SIGNAL(clicked()),
							this,SLOT(slotAbout()), true, i18n("About"));
	toolBar()->alignItemRight(3, true);
}

void Tuneroid::initEngine()
{
	m_engine = new ThreadEngine(this);

	connect(m_engine, SIGNAL(signalFreqChanged(float)),
			m_lcdDisplay, SLOT(slotChangeFrequency(float)));
	connect(m_engine, SIGNAL(signalIndicatorChanged(int)),
			m_lcdDisplay, SLOT(slotChangeIndicator(int)));
	connect(m_engine, SIGNAL(signalToneChanged(int)),
			m_lcdDisplay, SLOT(slotChangeTone(int)));

	connect(m_engine, SIGNAL(signalThreadError(QString)),
			this, SLOT(slotErrorMessage(QString)));

	startTimer(300);
}

void Tuneroid::timerEvent(QTimerEvent*)
{
	killTimers();
	m_engine->startThread();
}

void Tuneroid::slotErrorMessage(QString message)
{
#ifdef _DEBUG
	std::cerr << message.latin1() << std::endl;
#endif

	KMessageBox::error(this, message);
}

void Tuneroid::slotAbout()
{
	KAboutApplication aboutDialog(this);
	aboutDialog.exec();
}
