/***************************************************************************
					tuneroptions.cpp  -  description
						 -------------------
		begin                : Tue Jul 4 2000
		copyright            : (C) 2000 by Jozef Kosoru
		email                : jozef.kosoru@pobox.sk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "control.h"
#include <kglobal.h>
#include <kconfig.h>
#include "tuneroptions.h"
#include "alsasound.h"

TunerOptions::TunerOptions()
 : m_bFromFile(false)
{
	readOptions();
}

TunerOptions::~TunerOptions()
{
	saveOptions();
}

void TunerOptions::readOptions()
{
	KConfig* conf = KGlobal::config();

	conf->setGroup("SoundCard");
	m_iSamplerate = conf->readNumEntry("samplerate", 44100);
	m_iSamplerate_real = m_iSamplerate;
	m_iResolution = conf->readNumEntry("resolution", 16);

	m_iCardNumber = conf->readNumEntry("card_number", 0);
	m_iDeviceNumber = conf->readNumEntry("device_number", 0);
	m_iBufferTime = conf->readNumEntry("buffer_time", 250);
	m_bUsePcmString = conf->readBoolEntry("use_pcm_string" , true);
	m_sPcmName = conf->readEntry("pcm_name", QString::fromLatin1("default")).latin1();

	conf->setGroup("PitchDetector");
	m_threshold = static_cast<float>(conf->readDoubleNumEntry("threshold", 0.1));
	m_maxFreq = conf->readNumEntry("maxFreq", 20000);
	m_minFreq = conf->readNumEntry("minFreq", 20);
	m_maxFreqDif = static_cast<float>(conf->readDoubleNumEntry("maxFreqDif", 0.2));
	m_maxAmpDif = static_cast<float>(conf->readDoubleNumEntry("maxAmpDif", 0.5));
	m_minPeaksAmount = conf->readNumEntry("minPeaksAmount", 5);
	m_calibration = static_cast<float>(conf->readDoubleNumEntry("calibration", 1.0));

	conf->setGroup("ToneDetermine");
	m_freqOf_A = static_cast<float>(conf->readDoubleNumEntry("freqOf_A", 440.0));

	AlsaSound::fillDeviceList(this);
}

void TunerOptions::saveOptions()
{
	KConfig* conf = KGlobal::config();
	conf->setGroup("SoundCard");
	conf->writeEntry("samplerate", m_iSamplerate);
	conf->writeEntry("resolution", m_iResolution);
	conf->writeEntry("card_number", m_iCardNumber);
	conf->writeEntry("device_number", m_iDeviceNumber);
	conf->writeEntry("buffer_time", m_iBufferTime);
	conf->writeEntry("use_pcm_string", m_bUsePcmString);
	conf->writeEntry("pcm_name", QString::fromLatin1(m_sPcmName.c_str()));

	conf->setGroup("PitchDetector");
	conf->writeEntry("threshold", m_threshold);
	conf->writeEntry("maxFreq", m_maxFreq);
	conf->writeEntry("minFreq", m_minFreq);
	conf->writeEntry("maxFreqDif", m_maxFreqDif);
	conf->writeEntry("maxAmpDif", m_maxAmpDif);
	conf->writeEntry("minPeaksAmount", m_minPeaksAmount);
	conf->writeEntry("calibration", m_calibration);

	conf->setGroup("ToneDetermine");
	conf->writeEntry("freqOf_A", m_freqOf_A);
}
