import math

class Pluggable(list):
    def __call__(self, f):
        self.append(f)
        return f

def byteformat(n, units=('B', 'KiB', 'MiB', 'GiB', 'TiB')):
    """Format a number of bytes"""
    i = n and int(math.log(n, 1024)) or 0
    if i >= len(units):
        i = len(units)-1
    n /= 1024.0**i
    return "%.2f %s" % (n, units[i])

