#!/bin/sh
#
# %coypright%
#
# Please report bugs to: %maintainer%
#
# %license%
#
# Configuration guessing script for KMyFirewall %version%
# This is an automatic generated file DO NOT EDIT
#
# Exaple output
# <targetconfig name="Untitled" description="No Description Available" >
#   <interface name="eth0" />
#   <interface name="lo" />
#   <os name="linux" />
#   <backend name="iptables" />
#   <distribution name="sysv" />
#   <initPath name="/etc/init.d" />
#   <IPTPath name="/sbin/iptables" />
#   <modprobePath name="/sbin/modprobe" />
#   <rcDefaultPath name="/etc/rc2.d" />
# </targetconfig>
#

REQUIREDOS="Linux"
REQUIREDTOOLS="bash stat ifconfig grep sort cut"
INERACTIVE="0"
XMLCONFIG=""
DIST="sysv"


checkRequirements() {
	if [ "$INERACTIVE" = "1" ]; then
		echo "Checking system requirements"
	fi
	
	OS=`uname`
	if  [ "$OS" != "$REQUIREDOS" ]; then
		
		echo
		echo "ERROR: Wrong OS: $OS"
		echo "ERROR: This scripts is written for $REQUIREDOS"
		echo
		exit 1
	fi
	
	for PROG in $REQUIREDTOOLS; do
		if [ "$INERACTIVE" = "1" ]; then
			echo -n  "Checking for $PROG...\t\t "
		fi
		PROGPATH=""
		PROGNAME="which"
		SEARCH="/bin /sbin /usr/bin /usr/sbin"
		for s in $SEARCH; do
			if [ -e "$s/$PROGNAME" ]; then
				PROGPATH="$s/$PROGNAME";
			fi
		done
		
		if [ "$PROGPATH" != "" ]; then
			PROGPATH=`which $PROG`
			if [ "$?" != "0" ]; then
				echo
				echo "ERROR: $PROG not found. Installation aborted!"
				echo 
				exit 1
			fi
			if [ "$INERACTIVE" = "1" ]; then
				echo " found $PROG at $PROGPATH"
			fi
		else
			if [ "$INERACTIVE" = "1" ]; then
				echo "Requirement Checks Faild"
			fi
		fi
	done
	if [ "$INERACTIVE" = "1" ]; then
		echo 
	fi
}



writeXmlHeader() {
	XMLCONFIG=$XMLCONFIG"<targetconfig name=\"Untitled\" description=\"No Description Available\"><os name=\"linux\" /><backend name=\"iptables\" />";
}

writeXmlFooter() {
	XMLCONFIG=$XMLCONFIG"</targetconfig>";
}


checkDist() {
	if [ -e /etc/slackware-version ]; then
		setslakware;
		return;
	fi
	
	if [ -e /usr/bin/emerge ]; then
		setgentoo;
		return;
	fi
	setSysv
}

setSlakware() {
	#echo "Set To Slackware"
	DIST="slackware"
	XMLCONFIG=$XMLCONFIG"<distribution name=\"slackware\" />";
}

setGentoo() {
	#echo "Set To Gentoo"
	DIST="gentoo"
	XMLCONFIG=$XMLCONFIG"<distribution name=\"gentoo\" />";
}

setSysv() {
	#echo "Set To SysV"
	DIST="sysv"
	XMLCONFIG=$XMLCONFIG"<distribution name=\"sysv\" />";
}

setIPTables() {
	PROGNAME="iptables"
	SEARCH="/bin /sbin /usr/bin /usr/sbin"
	for s in $SEARCH; do
		if [ -e "$s/$PROGNAME" ]; then
			XMLCONFIG=$XMLCONFIG"<IPTPath name=\"$s/$PROGNAME\" />";
		fi
		
	done
}

setModprobe() {
	PROGNAME="modprobe"
	SEARCH="/ /bin /sbin /usr/bin /usr/sbin"
	for s in $SEARCH; do
		if [ -e "$s/$PROGNAME" ]; then
			XMLCONFIG=$XMLCONFIG"<modprobePath name=\"$s/$PROGNAME\" />";
		fi
		
	done
}

setInitDir() {
	SEARCH="/init.d /etc/init.d /etc/sbin.d"
	for s in $SEARCH; do
		if [ -e "$s" ]; then
			XMLCONFIG=$XMLCONFIG"<initPath name=\"$s\" />";
		fi
		
	done
}

setDefaultRunlevelDir() {
	if [ -e /etc/debian_version ]; then
		XMLCONFIG=$XMLCONFIG"<rcDefaultPath name=\"/etc/rc2.d\" />";
		return
	fi
	
	SEARCH="/etc/runlevels/default/ /etc/init.d/rc5.d /etc/rc5.d /sbin/rc5.d"
	
	for s in $SEARCH; do
		if [ -d "$s" ]; then
			XMLCONFIG=$XMLCONFIG"<rcDefaultPath name=\"$s\" />";
			return
		fi
	done
}

setInterfaces() {
	RET=`/sbin/ifconfig | grep ' Link' | cut -f1 -d' ' | sort`
	for i in $RET; do
		# echo "Found Interface: $i"
		XMLCONFIG=$XMLCONFIG"<interface name=\"$i\" />";
	done
}

returnXml() {
	echo $XMLCONFIG
}

printHello() {
    if [ "$INERACTIVE" = "1" ]; then
    	echo "KMyFirewall Auto Configuration Helper"
    	echo "Please report bugs to: %maintainer%"
    	echo
    fi
}

printHelp() {
	echo "Usage: $0 [-q] { --install | --uninstall | --reinstall | --extract | --start | --stop | --help }"
	echo
	echo "Switches"
	echo "	-q"
	echo "		Do not require any user interaction."
	echo
# 	echo "Options:"
# 	echo "	install|--install|-i"
# 	echo "		Install the configuration."
# 	echo "		The installed firewall scrip will be automaticaly run at system boot."
# 	echo 
# 	echo "	uninstall|--uninstall|-u"
# 	echo "		Uninstall the configuration form the system."
# 	echo 
# 	echo "	reinstall|--reinstall|-r"
# 	echo "		Re-Installs the configuration e.g. the same as install.sh uninstall"
# 	echo "		followed by install.sh install"
# 	echo
# 	echo "	extract|--extract|-e"
# 	echo "		Only extract the installation files."
# 	echo "		The firewall will not be installed."
# 	echo 
# 	echo "	start|--start|-s"
# 	echo "		Only extract the installation files and."
# 	echo "		runs the firewall script."
# 	echo "		The firewall will not be installed."
# 	echo 
# 	echo "	stop|--stop|-c"
# 	echo "		Only extract the installation files and."
# 	echo "		stops the firewall script."
# 	echo "		The firewall will not be installed."
# 	echo 
# 	echo "	help|--help|-h"
# 	echo "		Print this help message"
# 	echo
}

#
# Execution starts here
#

printHello

COMMAND=$1

if [ "$COMMAND" = "-q" ]; then
	COMMAND="$2"
	INERACTIVE="0";
fi

case $COMMAND in
	
	help|--help|-h)
	printHelp
	;;

	*)
	checkRequirements
	writeXmlHeader
	checkDist
	setIPTables
	setModprobe
	setInitDir
	setDefaultRunlevelDir
	setInterfaces
	writeXmlFooter
	returnXml
    ;;
esac

exit 0