//
// C++ Interface:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef KMFINTERFACEWIDGET_H
#define KMFINTERFACEWIDGET_H

#include "kmyfirewallinterfacewidget.h"

#include <qstring.h>

#include <qguardedptr.h>

class QStringList;

namespace KMF {
class KMFTarget;

class KMFInterfaceWidget : public KMyFirewallInterfaceWidget {
	Q_OBJECT

public:
	KMFInterfaceWidget( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~KMFInterfaceWidget();
	/*$PUBLIC_FUNCTIONS$*/
	void addInterface( const QString& interface );
	void addInterfaces( QStringList interfaces );
	void clear();
	
	void loadTarget( KMFTarget* target );
	
	QStringList interfaces();
	
public slots:
	/*$PUBLIC_SLOTS$*/
	void slotDelInterface();
	void slotAddInterface();
	

protected:
	/*$PROTECTED_FUNCTIONS$*/
	void updateView();

protected slots:
	/*$PROTECTED_SLOTS$*/

signals:
		void sigTargetChanged();
		
private: 
	QGuardedPtr<KMFTarget> m_target;
};
}
#endif

