//
// C++ Interface: kmfiptdocview
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFIPTDOCVIEW_H
#define KMFIPTDOCVIEW_H

#include <qtabwidget.h>


#include "kmflistview.h"

// Project includes

namespace KMF {
class KMFIPTDoc;
class IPTable;

/**
@author Christian Hubinger
*/
class KMFIPTDocView : public QTabWidget
{
Q_OBJECT
public:
    KMFIPTDocView(QWidget *parent = 0, const char *name = 0);

    ~KMFIPTDocView();

KMFListView* filterView() const {
	return m_iptViewFilter;
};

KMFListView* natView() const {
	return m_iptViewNat;
};

KMFListView* mangleView() const {
	return m_iptViewMangle;
};


public slots:
	void slotLoadDoc( KMFIPTDoc* );
	void slotLoadTable( IPTable* );
	void close();
	void show();
	void hide();
	
private:
	KMFListView *m_iptViewFilter;
	KMFListView *m_iptViewNat;
	KMFListView *m_iptViewMangle;
	bool loaded;

signals:
	void closing();
	void showing();

};
}
#endif
