/***************************************************************************
 begin                : Wed Mar 27 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleeditortos.h"

// QT includes
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qstring.h>
#include <qlabel.h>
#include <qgroupbox.h>

// kde includes
#include <klocale.h>
#include <kdebug.h>
#include <kapplication.h>

// project includes
#include "../../core/xmlnames.h"
#include "../../core/iptruleoption.h"
#include "../../core/iptrule.h"
#include "../../core/iptchain.h"
#include "../../core/iptable.h"
#include "../../core/kmfdoc.h"
#include "../../core/kmfiptdoc.h"
#include "../../core/kmfnetwork.h"
#include "../../core/kmfundoengine.h"
namespace KMF {
KMFRuleEditorTos::KMFRuleEditorTos( QWidget *parent, const char *name, WFlags fl ) : KMyFirewallRuleEditorTos( parent, name, fl ) {
	m_option_type = "CHECKTOS";
}
KMFRuleEditorTos::~KMFRuleEditorTos() {}

void KMFRuleEditorTos::setType( const QString& type ) {
	m_option_type = type;
	if ( m_option_type == "SETTOS" ) {
		gb_title->setTitle( i18n( "Set Type of Service" ) );
		c_use_tos->setText( i18n( "Set TOS" ) );
		setItems();
	} else if ( m_option_type == "CHECKTOS" ) {
		gb_title->setTitle( i18n( "Match Type of Service" ) );
		c_use_tos->setText( i18n( "Check TOS" ) );
		setItems();
	} else if ( m_option_type == "REJECTTYPE" ) {
		gb_title->setTitle( i18n( "Reject with icmp-type" ) );
		c_use_tos->setText( i18n( "Reject with type:" ) );
		setItems();
	}
}

void KMFRuleEditorTos::loadRule( IPTRule* rule ) {
	kdDebug() << "void KMFRuleEditorTos::loadRule( IPTRule* rule )" << endl;
	m_rule = rule;
	if ( m_option_type == "SETTOS" ) {
		setItems();
		IPTRuleOption* opt = rule->getOptionForName("target_set_tos_opt");
		if ( ! opt ->isEmpty()) {
			QStringList values = opt->getValues();
			QString val = *values.at(0);
			if ( val != XML::Undefined_Value  ) {
				c_use_tos->setChecked( true );
				int index = getItemNum( val );
				if ( index > 0 )
					cb_tos->setCurrentItem( index );
			} else {
				c_use_tos->setChecked( false );
			}
		} else {
			c_use_tos->setChecked( false );
		}
	} else if ( m_option_type == "CHECKTOS" ) {
		setItems();
		IPTRuleOption* opt = rule->getOptionForName("tos_opt");
		if ( ! opt ->isEmpty() ) {
			QStringList values = opt->getValues();
			QString val = *values.at(0);
			if ( val == XML::BoolOn_Value ) {
				QString val2 = *values.at(1);
				c_use_tos->setChecked( true );
				int index = getItemNum( val2 );
				if ( index > 0 )
					cb_tos->setCurrentItem( index );
			} else {
				c_use_tos->setChecked( false );
			}
		} else {
			c_use_tos->setChecked( false );
		}
	} else if ( m_option_type == "REJECTTYPE" ) {
		setItems();
		IPTRuleOption* opt = rule->getOptionForName("target_reject_type_opt");
		if ( ! opt ->isEmpty() ) {
			QStringList values = opt->getValues();
			QString val = *values.at(0);
			if ( val != XML::Undefined_Value) {
				c_use_tos->setChecked( true );
				int index = getItemNum( val );
				if ( index > 0 )
					cb_tos->setCurrentItem( index );
			} else {
				c_use_tos->setChecked( false );
			}
		} else {
			c_use_tos->setChecked( false );
		}
	} else {
		kdDebug() << "Misuse of this class no type set !!" << endl;
	}
}

void KMFRuleEditorTos::accept() {
	KMFUndoEngine::instance()->startTransaction( 
		m_rule,
		i18n("Edit Rule: %1 TOS Option").arg( m_rule->name() ) 
	);
	if ( m_option_type == "SETTOS" ) {
		bool use_tos = c_use_tos->isChecked();
		QPtrList<QString>* options = new QPtrList<QString>;
		QString* name = new QString( "target_set_tos_opt" );
		if ( use_tos ) {
			QString val = cb_tos->currentText();
			options->append( new QString( val ) );
		} else {
			options->append( new QString( XML::BoolOff_Value) );
		}
		// emit sigAddTargetOpt( name, options );
		m_rule->addTargetOption( *name, *options );
		KMFUndoEngine::instance()->endTransaction();
		emit sigDocumentChanged();
	} else if ( m_option_type == "CHECKTOS" ) {
		bool use_tos = c_use_tos->isChecked();
		QPtrList<QString>* options = new QPtrList<QString>;
		QString* name = new QString( "tos_opt" );
		if ( use_tos ) {
			QString val = cb_tos->currentText();
			options->append( new QString( XML::BoolOn_Value) );
			options->append( new QString( val ) );
		} else {
			options->append( new QString( XML::BoolOff_Value) );
		}
		// emit sigAddRuleOpt( name, options );
		m_rule->addRuleOption( *name, *options );
		KMFUndoEngine::instance()->endTransaction();
		emit sigHideMe();

	} else if ( m_option_type == "REJECTTYPE" ) {
		bool use_tos = c_use_tos->isChecked();
			QPtrList<QString>* options = new QPtrList<QString>;
			QString* name = new QString( "target_reject_type_opt" );
		if ( use_tos ) {
			QString val = cb_tos->currentText();
			options->append( new QString( val ) );
		} else {
			options->append( new QString( XML::BoolOff_Value) );
		}
		// emit sigAddTargetOpt( name, options );
		m_rule->addTargetOption( *name, *options );
		KMFUndoEngine::instance()->endTransaction();
		emit sigHideMe();
	}
	KMFUndoEngine::instance()->abortTransaction();
}

void KMFRuleEditorTos::setItems() {
	kdDebug() << "void KMFRuleEditorTos::setItems(const QString& type)" << endl;
	cb_tos->clear();
	if ( m_option_type == "SETTOS" || m_option_type == "CHECKTOS" ) {
		cb_tos->insertItem( "Normal-Service" );
		cb_tos->insertItem( "Minimize-Cost" );
		cb_tos->insertItem( "Maximize-Reliability" );
		cb_tos->insertItem( "Maximize-Throughput" );
		cb_tos->insertItem( "Minimize-Delay" );
	} else if ( m_option_type == "REJECTTYPE" ) {
		cb_tos->insertItem( "icmp-port-unreachable" );
		cb_tos->insertItem( "icmp-net-unreachable" );
		cb_tos->insertItem( "icmp-host-unreachable" );
		cb_tos->insertItem( "icmp-proto-unreachable" );
		cb_tos->insertItem( "icmp-net-prohibited" );
		cb_tos->insertItem( "icmp-host-prohibited" );
	}
}

int KMFRuleEditorTos::getItemNum( const QString& option ) {
	kdDebug() << "int KMFRuleEditorTos::getItemNum(const QString& option)" << endl;
	int index = -1;
	for ( int i = 0; i < cb_tos->count(); i++ ) {
		QString tmp_item = cb_tos->text( i );
		if ( tmp_item == option ) {
			index = i;
		}
	}
	return index;
}

void KMFRuleEditorTos::slotHelp() {
	kdDebug() << "void KMFRuleEditorTos::slotHelp()" << endl;
	kapp->invokeHelp( "tos" );
}

void KMFRuleEditorTos::reject() {
	kdDebug() << "void KMFRuleEditorTos::reject()" << endl;
	loadRule(m_rule);
	emit sigHideMe();
}

}
#include "kmfruleeditortos.moc"
