/***************************************************************************
 *
 * knetworkmanager-vpnplugin.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_VPNPLUGIN_H
#define KNETWORKMANAGER_VPNPLUGIN_H

#include <qwidget.h>
#include <qmap.h>
#include <dbus/qdbusdata.h>
#include <dbus/qdbusvariant.h>
#include "knetworkmanager-plugin.h"

#define KNETWORKMANAGER_VPNPLUGIN "KNetworkManager/VPNPlugin"

class VPNConfigWidget : public QWidget
{
	Q_OBJECT
	public:
		virtual ~VPNConfigWidget();
		VPNConfigWidget(QWidget* parent = NULL, const char* name = NULL); 

		virtual void setVPNData(const QStringList&, const QMap<QString,QString>&);	
		virtual QMap<QString, QString> getVPNProperties();
		virtual QStringList getVPNRoutes();
		virtual bool hasChanged();
		virtual bool isValid(QStringList&);
};

class VPNAuthenticationWidget : public QWidget
{
	Q_OBJECT
	public:
		virtual ~VPNAuthenticationWidget();
		VPNAuthenticationWidget(QWidget* parent = NULL, const char* name = NULL);
		
		virtual void setVPNData(const QStringList&, const QMap<QString, QString>&);
		virtual QMap<QString, QString> getPasswords();
		virtual bool needsUserInteraction();
};

class VPNPlugin : public Plugin
{
	Q_OBJECT
	public:
		VPNPlugin(QObject*, const char*, const QStringList&);
		virtual ~VPNPlugin();

		virtual VPNConfigWidget* CreateConfigWidget(QWidget* parent = 0);
		virtual VPNAuthenticationWidget* CreateAuthenticationWidget(QWidget* parent = 0);
};


#endif /* KNETWORKMANAGER_VPNPLUGIN_H */

