#include <qmessagebox.h>
#include <qtable.h>
#include <qfile.h>
#include <qdir.h>
#include <qfiledialog.h>
#include <qtextstream.h>
#include "frmips.h"

const QString appVer = "1.5.1";

struct protoPort
{
	unsigned short int portNumber;
	unsigned int count;
	protoPort * next;
	protoPort * previous;
};

void Form1::init()
{
	QFile fin(QDir::homeDirPath() + "/.NetfilterStatsBuilder/settings.conf");
	
	if (fin.exists())
	{
		fin.open(IO_ReadOnly);
		
		QTextStream stream(&fin);
		
		txtFileInPath->setText(stream.readLine());
		txtFileOutPath->setText(stream.readLine());
		
		fin.close();
	}
}

void Form1::OnGo()
{
	disableEnable(1);
	
	unsigned int realnum = 0;
		
    	QString line;

    	QFile fin0(txtFileInPath->text());
	QTextStream streamin0(&fin0);

	listElem * first = NULL;
	listElem * last = NULL;
	listElem * buffer = first;

	bool found = false;

	if (fin0.exists() && !txtFileOutPath->text().isEmpty())
    	{
		setCursor(Qt::WaitCursor);
			
		fin0.open(IO_ReadOnly);
	
		while (!fin0.atEnd())
		{
	    		line = streamin0.readLine();
			
	    		int src = line.find("SRC=");
	    		unsigned int src_space = line.find(" ", src);
			
			int proto = line.find("PROTO=");
			unsigned int proto_space = line.find(" ", proto);

			int port = line.find("DPT=");
			unsigned int port_space;

			if ( !(port < 0) )
				port_space = line.find(" ", port);

			QString curip(line.mid((src + 4), (src_space - src - 4)));
			QString curproto(line.mid((proto + 6), (proto_space - proto - 6)));
			QString dstport(QString::null);

			if (curproto != "ICMP")
				dstport = line.mid((port + 4), (port_space - port - 4));
			
			found = false;

	    		if ( !(src < 0) )
	    		{	
				buffer = first;

				while (buffer)
				{
					if (buffer->packet.getIp() == curip)
					{
						found = true;
						
						if (curproto == "TCP")
							buffer->packet.incrTcp(dstport.toShort());
						else
						{
							if (curproto == "UDP")
								buffer->packet.incrUdp(dstport.toShort());
							else
								buffer->packet.incrIcmp();
						}
						
						if (buffer->previous)
						{
							listElem * insertAfter = buffer->previous;

							while ( buffer->packet.getCount() > insertAfter->packet.getCount() )
							{
								insertAfter = insertAfter->previous;

								if (!insertAfter) break;
							}
							
							buffer->previous->next = buffer->next;
		
							if (!buffer->next)
								last = buffer->previous;
							else
								buffer->next->previous = buffer->previous;

							buffer->previous = insertAfter;

							if (insertAfter)
							{
								buffer->next = insertAfter->next;
							
								if (insertAfter->next)
									insertAfter->next->previous = buffer;
								else
									last = buffer;

								insertAfter->next = buffer;
							}
							else
							{
								buffer->next = first;
								first->previous = buffer;
								first = buffer;
							}
						}

						break;
					}
					else
						buffer = buffer->next;
				}
				
				if (!found)
				{
					listElem * current = new listElem;

					current->previous = NULL;
					current->next = NULL;

					current->packet.setIp(curip);
					
					if (curproto == "TCP")
						current->packet.incrTcp(dstport.toShort());
					else
					{
						if (curproto == "UDP")
							current->packet.incrUdp(dstport.toShort());
						else
							current->packet.incrIcmp();
					}

					if (!first)
					{
						first = current;
						last = first;
					}
					else
					{
						current->previous = last;
						last->next = current;
						last = current;
					}
					
					realnum++;
				}
			}
			
			if (prgProgress->progress() == prgProgress->totalSteps())
				prgProgress->setProgress(0);
			else
				prgProgress->setProgress(prgProgress->progress() + 1);
		}
	
		prgProgress->setProgress(prgProgress->totalSteps());

		fin0.close();
		
		QFile fout(txtFileOutPath->text());

		if (fout.exists())
		{
			QMessageBox msg("Warning", "Output file already exists!\nOverwrite?",
				QMessageBox::Warning, QMessageBox::No, QMessageBox::Yes, QMessageBox::NoButton);
			int res = msg.exec();

			if (res == QMessageBox::No)
			{
				txtFileOutPath->setText(txtFileOutPath->text() + " [RENAMED]");
				fout.setName(txtFileOutPath->text());
			}
		}

    		QTextStream streamout(&fout);
	
    		fout.open(IO_WriteOnly);
   
    		streamout << "#\n# Generated by NetfilterStatsBuilder-"
			<< appVer
			<< "\n# amdfanatyk (at) wp (dot) pl\n#\n# homepage: http://amdfanatyk.w.interia.pl\n#";
				

		frmIps frm(this);
		
		buffer = first;

		while (buffer)
		{
			streamout
				<< "\n<IP>"
				<< buffer->packet.getIp()
				<< "</IP>"
				<< "\n\t<COUNT>"
				<< QString::number(buffer->packet.getCount())
				<< "</COUNT>"
				<< "\n\t<TCP>"
				<< QString::number(buffer->packet.getTcp())
				<< "</TCP>";

			if (buffer->packet.getTcpPortHandle())
				savePorts(buffer->packet.getTcpPortHandle(), streamout);

			streamout
				<< "\n\t<UDP>"
				<< QString::number(buffer->packet.getUdp())
				<< "</UDP>";

			if (buffer->packet.getUdpPortHandle())
				savePorts(buffer->packet.getUdpPortHandle(), streamout);
			
			streamout
				<< "\n\t<ICMP>"
				<< QString::number(buffer->packet.getIcmp())
				<< "</ICMP>";

			frm.tblIps->insertRows(frm.tblIps->numRows());
			frm.tblIps->setText(frm.tblIps->numRows() - 1, 0, buffer->packet.getIp());
			frm.tblIps->setText(frm.tblIps->numRows() - 1, 1, QString::number(buffer->packet.getCount()));
			frm.tblIps->setText(frm.tblIps->numRows() - 1, 2, QString::number(buffer->packet.getTcp()));
			frm.tblIps->setText(frm.tblIps->numRows() - 1, 3, QString::number(buffer->packet.getUdp()));
			frm.tblIps->setText(frm.tblIps->numRows() - 1, 4, QString::number(buffer->packet.getIcmp()));

			buffer = buffer->next;
		}
		
		streamout << "\n# " << QString::number(realnum) + " different ips have been found!\n";

     		fout.close();
     
     		setCursor(Qt::ArrowCursor);

		frm.firstElem = first;
		frm.setCaption(QString::number(realnum) + " different ips have been found!\n");
		frm.exec();

		buffer = first;
		listElem * nextElem = buffer;
	
		while (buffer)
		{
			nextElem = buffer->next;
			delete buffer;
			buffer = nextElem;
		}
	}
	else
	{
		QMessageBox msg("Error", "Input file doesn't exist and/or output file wasn't specified!",
			QMessageBox::Critical, QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
		msg.exec();
	}
	
	disableEnable(0);
}

void Form1::savePorts(nod * currentNod, QTextStream & strOut)
{
	if (currentNod->left)
		savePorts(currentNod->left, strOut);

	strOut
		<< "\n\t\t<PORT>"
		<< currentNod->portNumber
		<< "</PORT>"
		<< "\n\t\t\t<COUNT>"
		<< currentNod->count
		<< "</COUNT>";

	if (currentNod->right)
		savePorts(currentNod->right, strOut);	
}

void Form1::OnBrowse()
{
	QString path;
	path = QFileDialog::getOpenFileName
								(
									"/home",
									"all files (*)",
									this,
					        			"",
					       				"open"
					       			);
	if (!path.isEmpty())
		txtFileInPath->setText(path);
}


void Form1::OnBrowseSave()
{
	QString path;
	path = QFileDialog::getSaveFileName
								(
									"/home",
									"all files (*)",
									this,
					        			"",
					       				"save"
					       			);
	if (!path.isEmpty())
		txtFileOutPath->setText(path);
}

void Form1::closeEvent(QCloseEvent * e)
{
	QDir dir(QDir::homeDirPath() + "/.NetfilterStatsBuilder");
	
	if (!dir.exists())
		QDir().mkdir(dir.path());
	
	QFile fout(dir.path() + "/settings.conf");
	QTextStream stream(&fout);
	
	fout.open(IO_WriteOnly);
	
	stream << txtFileInPath->text() << "\n" << txtFileOutPath->text();
	
	fout.close();
		
	e->accept();
}

void Form1::OnAbout()
{
	QMessageBox msg("about", "<b>NetfilterStatsBuilder</b>-<i>" + appVer + "</i><br><br><b>programming</b>:<br>amdfanatyk<br><br><b>licence</b>: GPL",
		QMessageBox::Information, QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
	msg.exec();
}

void Form1::openOutputFile(bool existing)
{
	disableEnable(1);
	
	QString path;

	if (existing)
	{
		path = QFileDialog::getOpenFileName
								(
									"/home",
									"all files (*)",
									this,
					        			"",
					       				"open"
					       			);
	}
	else
		path = txtFileOutPath->text();

	QFile fin(path);

	if (fin.exists())
	{
		fin.open(IO_ReadOnly);

		QTextStream streamin(&fin);
		QString line(QString::null),
			ip(QString::null),
			total(QString::null),
			tcp(QString::null),
			udp(QString::null),
			icmp(QString::null);
		unsigned int count = 0;
		listElem * firstListElem = NULL;
		listElem * lastListElem = NULL;
		frmIps frm(this);

		setCursor(Qt::WaitCursor);

		while (!fin.atEnd())
		{
			line = streamin.readLine();
			
			if (line.left(4) == "<IP>")
			{
				count++;

				ip = line.mid( 4, line.find("</IP>", 4) - 4 );
				line = streamin.readLine();
				total = line.mid( 8, line.find("</COUNT>", 8) - 8 );
				line = streamin.readLine();
				
				tcp = line.mid( 6, line.find("</TCP>", 6) - 6 );
				line = streamin.readLine();

				listElem * newElem = new listElem;
				
				newElem->packet.setIp(ip);
				newElem->next = NULL;
				newElem->previous = NULL;

				if (lastListElem)
				{
					lastListElem->next = newElem;
					newElem->previous = lastListElem;
					lastListElem = newElem;
				}
				else
				{
					firstListElem = newElem;
					lastListElem = firstListElem;
				}

				while ( line.mid(2, 6) == "<PORT>" )
				{
					QString portNumber(  line.mid( 8, line.find("</PORT>", 8) - 8 )  );
					line = streamin.readLine();
					QString portCount(  line.mid( 10, line.find("</COUNT>", 10) - 10 )  );

					newElem->packet.setTcp(portNumber.toShort(), portCount.toUInt());

					line = streamin.readLine();
				}
				
				udp = line.mid( 6, line.find("</UDP>", 6) - 6 );
				line = streamin.readLine();

				while ( line.mid(2, 6) == "<PORT>" )
				{
					QString portNumber(  line.mid( 8, line.find("</PORT>", 8) - 8 )  );
					line = streamin.readLine();
					QString portCount(  line.mid( 10, line.find("</COUNT>", 10) - 10 )  );

					newElem->packet.setUdp(portNumber.toShort(), portCount.toUInt());

					line = streamin.readLine();
				}

				icmp = line.mid( 7, line.find("</ICMP>", 7) - 7 );

				newElem->packet.setIcmp(icmp.toUInt());

				frm.tblIps->insertRows(frm.tblIps->numRows());
				frm.tblIps->setText(frm.tblIps->numRows() - 1, 0, ip);
				frm.tblIps->setText(frm.tblIps->numRows() - 1, 1, total);
				frm.tblIps->setText(frm.tblIps->numRows() - 1, 2, tcp);
				frm.tblIps->setText(frm.tblIps->numRows() - 1, 3, udp);
				frm.tblIps->setText(frm.tblIps->numRows() - 1, 4, icmp);
			}

			if (prgProgress->progress() == prgProgress->totalSteps())
				prgProgress->setProgress(0);
			else
				prgProgress->setProgress(prgProgress->progress() + 1);
		}

		setCursor(Qt::ArrowCursor);

		frm.setCaption(QString::number(count) + " different ips have been found!");

		prgProgress->setProgress(prgProgress->totalSteps());

		if (count)
		{
			frm.firstElem = firstListElem;
			frm.exec();
			
			listElem * buffer = firstListElem;
			listElem * nextElem = buffer;
	
			while (buffer)
			{
				nextElem = buffer->next;
				delete buffer;
				buffer = nextElem;
			}
		}
		else
		{
			QMessageBox msg("Error", path + "\nisn't correct output file!",
				QMessageBox::Critical, QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
			msg.exec();
		}
	}
	else
	{
		if (!path.isEmpty())
		{
			QMessageBox msg("Error", "Input file doesn't exist!",
				QMessageBox::Critical, QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
			msg.exec();
		}
	}

	disableEnable(0);
}


void Form1::onOpenExisting()
{
	openOutputFile(true);
}


void Form1::onOpenCurrent()
{
	openOutputFile(false);
}

void Form1::disableEnable(bool disable)
{
	txtFileInPath->setEnabled(!disable);
	txtFileOutPath->setEnabled(!disable);
	pshBrowseOpen->setEnabled(!disable);
	pshBrowseSave->setEnabled(!disable);
	pshGo->setEnabled(!disable);
	pshOpenExisting->setEnabled(!disable);
	pshOpenCurrent->setEnabled(!disable);
}
