#include <qprocess.h>
#include <qtextedit.h>
#include "frminfo.h"

void frmIps::fillTcpPorts(nod * currentNod, frmPorts & frm)
{
	if (currentNod->left)
		fillTcpPorts(currentNod->left, frm);
	
	frm.tblPorts->insertRows(frm.tblPorts->numRows());
	frm.tblPorts->setText(frm.tblPorts->numRows() - 1, 0, QString::number(currentNod->portNumber));
	frm.tblPorts->setText(frm.tblPorts->numRows() - 1, 1, QString::number(currentNod->count));
	frm.tblPorts->setText(frm.tblPorts->numRows() - 1, 2, "0");
	
	if (currentNod->right)
		fillTcpPorts(currentNod->right, frm);
}

void frmIps::fillUdpPorts(nod * currentNod, frmPorts & frm)
{
	if (currentNod->left)
		fillUdpPorts(currentNod->left, frm);
	
	bool found = false;

	for (int i = 0 ; i < frm.tblPorts->numRows() ; i++)
	{
		if (frm.tblPorts->text(i, 0).toShort() == currentNod->portNumber)
		{
			found = true;
			frm.tblPorts->setText(i, 2, QString::number(currentNod->count));
		}
	}

	if (!found)
	{
		frm.tblPorts->insertRows(frm.tblPorts->numRows());
		frm.tblPorts->setText(frm.tblPorts->numRows() - 1, 0, QString::number(currentNod->portNumber));
		frm.tblPorts->setText(frm.tblPorts->numRows() - 1, 1, "0");
		frm.tblPorts->setText(frm.tblPorts->numRows() - 1, 2, QString::number(currentNod->count));
	}
	
	if (currentNod->right)
		fillUdpPorts(currentNod->right, frm);
}

void frmIps::clicked( int row, int col, int button, const QPoint & mousePos )
{
	if (tblIps->numRows() == 0)
		return;

	if (button == LeftButton)
	{
		QProcess whois;
		
		whois.addArgument("whois");
		whois.addArgument(tblIps->text(tblIps->currentRow(), 0));

		setCursor(Qt::WaitCursor);

		whois.start();
	
		while (whois.isRunning());

		setCursor(Qt::ArrowCursor);
				
		frmInfo info(this);
				
		info.lblInfo->setText(tblIps->text(tblIps->currentRow(), 1) +
			" packets" + 
			" (TCP=" + tblIps->text(tblIps->currentRow(), 2) + ")" +
			" (UDP=" + tblIps->text(tblIps->currentRow(), 3) + ")" + 
			" (ICMP=" + tblIps->text(tblIps->currentRow(), 4) + ")" + 
			" received from ip " + tblIps->text(tblIps->currentRow(), 0));
	
		QString output(whois.readStdout());

		int start = output.find("% Information related to");
	
		if ( !(start < 0) )
			output = output.mid(start, output.length() - start);

		info.txtInfo->setText(output);

		info.exec();
	}
	else
	{
		if (button == RightButton)
		{
			frmPorts frm(this);

			listElem * buffer = firstElem;

			while ( buffer->packet.getIp() != tblIps->text(tblIps->currentRow(), 0) )
				buffer = buffer->next;

			frm.setCaption("TCP=" + QString::number(buffer->packet.getTcp()) +
				" UDP=" + QString::number(buffer->packet.getUdp()) +
				" from ip " + buffer->packet.getIp());

			if (buffer->packet.getTcpPortHandle())
				fillTcpPorts(buffer->packet.getTcpPortHandle(), frm);

			if (buffer->packet.getUdpPortHandle())
				fillUdpPorts(buffer->packet.getUdpPortHandle(), frm);

			frm.exec();
		}
	}
}
