#include "packet.h"

CPacket::CPacket()
{
	setIp(QString::null);
	count = 0;
	tcp = 0;
	udp = 0;
	icmp = 0;

	tcpPortHandle = NULL;
	udpPortHandle = NULL;
}

CPacket::~CPacket()
{
	if (tcpPortHandle)
		destroyTree(tcpPortHandle);

	if (udpPortHandle)
		destroyTree(udpPortHandle);
}

void CPacket::setIp(QString newip)
{
	ip = newip;
}

QString CPacket::getIp()
{
	return ip;
}

unsigned int CPacket::getCount()
{
	return count;
}

void CPacket::incrTcp(unsigned short int portNumber)
{
	tcp++;
	count++;

	if (tcpPortHandle)
	{
		nod * port = searchNod(tcpPortHandle, portNumber);
		
		if (!port)
			port = insertNod(tcpPortHandle, portNumber);
			
		port->count++;
	}
	else
	{
		tcpPortHandle = new nod;
		tcpPortHandle->portNumber = portNumber;
		tcpPortHandle->count = 1;
		tcpPortHandle->left = NULL;
		tcpPortHandle->right = NULL;
	}
}

void CPacket::setTcp(unsigned short int portNumber, unsigned int portCount)
{
	tcp += portCount;
	count += portCount;

	if (tcpPortHandle)
	{
		nod * port = insertNod(tcpPortHandle, portNumber);
		port->count = portCount;
	}
	else
	{
		tcpPortHandle = new nod;
		tcpPortHandle->portNumber = portNumber;
		tcpPortHandle->count = portCount;
		tcpPortHandle->left = NULL;
		tcpPortHandle->right = NULL;
	}
}

unsigned int CPacket::getTcp()
{
	return tcp;
}

unsigned int CPacket::getTcpPort(unsigned short int portNumber)
{
	nod * port = searchNod(tcpPortHandle, portNumber);

	if (port)
		return port->count;
	else
		return 0;
}

void CPacket::incrUdp(unsigned short int portNumber)
{
	udp++;
	count++;

	if (udpPortHandle)
	{
 		nod * port = searchNod(udpPortHandle, portNumber);
		
		if (!port)
			port = insertNod(udpPortHandle, portNumber);

		port->count++;
	}
	else
	{
		udpPortHandle = new nod;
		udpPortHandle->portNumber = portNumber;
		udpPortHandle->count = 1;
		udpPortHandle->left = NULL;
		udpPortHandle->right = NULL;
	}
}

void CPacket::setUdp(unsigned short int portNumber, unsigned int portCount)
{
	udp += portCount;
	count += portCount;

	if (udpPortHandle)
	{
		nod * port = insertNod(udpPortHandle, portNumber);
		port->count = portCount;
	}
	else
	{
		udpPortHandle = new nod;
		udpPortHandle->portNumber = portNumber;
		udpPortHandle->count = portCount;
		udpPortHandle->left = NULL;
		udpPortHandle->right = NULL;
	}
}

unsigned int CPacket::getUdp()
{
	return udp;
}

unsigned int CPacket::getUdpPort(unsigned short int portNumber)
{
	nod * port = searchNod(udpPortHandle, portNumber);

	if (port)
		return port->count;
	else
		return 0;
}

void CPacket::incrIcmp()
{
	icmp++;
	count++;
}

void CPacket::setIcmp(unsigned int protoCount)
{
	icmp += protoCount;
	count += protoCount;
}

unsigned int CPacket::getIcmp()
{
	return icmp;
}

nod * CPacket::insertNod(nod * currentNod, unsigned short int & portNumber)
{
	if (portNumber < currentNod->portNumber)
	{
		if (currentNod->left == NULL)
		{
			nod * newNod = new nod;
			newNod->portNumber = portNumber;
			newNod->count = 0;
			newNod->left = NULL;
			newNod->right = NULL;
			currentNod->left = newNod;
			return newNod;
		}
		else
			return insertNod(currentNod->left, portNumber);
	}
	else
	{
		if (currentNod->right == NULL)
		{
			nod * newNod = new nod;
			newNod->portNumber = portNumber;
			newNod->count = 0;
			newNod->left = NULL;
			newNod->right = NULL;
			currentNod->right = newNod;
			return newNod;
		}
		else
			return insertNod(currentNod->right, portNumber);
	}
}

nod * CPacket::searchNod(nod * currentNod, unsigned short int & portNumber)
{
	if (currentNod->portNumber == portNumber)
		return currentNod;
	else
	{
		if (portNumber < currentNod->portNumber)
		{
			if (currentNod->left == NULL)
				return NULL;
			else
				return searchNod(currentNod->left, portNumber);
		}
		else
		{
			if (currentNod->right == NULL)
				return NULL;
			else
				return searchNod(currentNod->right, portNumber);
		}
	}
}

nod * CPacket::getTcpPortHandle()
{
	return tcpPortHandle;
}

nod * CPacket::getUdpPortHandle()
{
	return udpPortHandle;
}

void CPacket::destroyTree(nod * currentNod)
{
	if (currentNod->left)
		destroyTree(currentNod->left);

	if (currentNod->right)
		destroyTree(currentNod->right);

	delete currentNod;
}
