#pragma once
#include "qstring.h"

struct nod
{
	unsigned short int portNumber;
	unsigned int count;
	nod * left;
	nod * right;
};

class CPacket
{
	public:
		CPacket();
		~CPacket();
		void setIp(QString newip);
		QString getIp();
		unsigned int getCount();
		unsigned int getTcp();
		unsigned int getTcpPort(unsigned short int portNumber);
		unsigned int getUdp();
		unsigned int getUdpPort(unsigned short int portNumber);
		unsigned int getIcmp();
		void incrTcp(unsigned short int portNumber);
		void setTcp(unsigned short int portNumber, unsigned int portCount);
		void incrUdp(unsigned short int portNumber);
		void setUdp(unsigned short int portNumber, unsigned int portCount);
		void incrIcmp();
		void setIcmp(unsigned int protoCount);
		nod * searchNod(nod * currentNod, unsigned short int & portNumber);
		nod * insertNod(nod * currentNod, unsigned short int & portNumber);
		nod * getTcpPortHandle();
		nod * getUdpPortHandle();
		void destroyTree(nod * currentNod);

	private:
		QString ip;
		unsigned int count;
		unsigned int tcp;
		unsigned int udp;
		unsigned int icmp;
		nod * tcpPortHandle;
		nod * udpPortHandle;
};
